//
//  Town.swift
//  MonsterTown
//
//  Created by Robert Górczyński on 14/09/16.
//  Copyright © 2016 Robert Górczyński. All rights reserved.
//

import Foundation

struct Town {
    let region: String
    var population: Int {
        didSet(oldPopulation) {
            print("Wielkość populacji zmieniła się na \(population) z \(oldPopulation).")
        }
    }
    var numberOfStoplights: Int
    
    init?(region: String, population: Int, stoplights: Int) {
        if population <= 0 {
            return nil
        }
        self.region = region
        self.population = population
        numberOfStoplights = stoplights
    }
    
    init?(population: Int, stoplights: Int) {
        self.init(region: "brak danych", population: population, stoplights: stoplights)
    }

    
    enum Size {
        case małe
        case średnie
        case duże
    }
    
    var townSize: Size {
        get {
            switch self.population {
            case 0...10000:
                return Size.małe
                
            case 10001...100000:
                return Size.średnie
                
            default:
                return Size.duże
            }
        }
    }
    
    func printTownDescription() {
        print("Populacja: \(population), liczba skrzyżowań z sygnalizacją świetlną: \(numberOfStoplights), region: \(region).")
    }
    
    mutating func changePopulation(amount: Int) {
        population += amount
    }
}
