//
//  Asset.swift
//  CyclicalAssets
//
//  Created by Robert Górczyński on 27/09/16.
//  Copyright © 2016 Robert Górczyński. All rights reserved.
//

import Foundation

class Asset: CustomStringConvertible {
    let name: String
    let value: Double
    weak var owner: Person?
    
    var description: String {
        if let actualOwner = owner {
            return "Zasób(\(name) o wartości \(value), którego właścicielem jest \(actualOwner))"
        } else {
            return "Zasób(\(name) o wartości \(value), który nie ma właściciela)"
        }
    }
    
    init(name: String, value: Double) {
        self.name = name
        self.value = value
    }
    deinit {
        print("Egzemplarz \(self) został usunięty z pamięci.")
    }
}
