"""
Programowanie obiektowe w Pythonie 3

Rozdział 13., Testowanie oprogramowania obiektowego
"""
from __future__ import annotations
from typing import Any, Callable


def setup_module(module: Any) -> None:
    print(f"przygotowuję MODUŁ {module.__name__}")


def teardown_module(module: Any) -> None:
    print(f"porządkuję MODUŁ {module.__name__} po testach")


def test_a_function() -> None:
    print("WYKONUJĘ FUNKCJĘ TESTOWĄ")


class BaseTest:
    @classmethod
    def setup_class(cls: type["BaseTest"]) -> None:
        print(f"przygotowuję KLASĘ {cls.__name__}")

    @classmethod
    def teardown_class(cls: type["BaseTest"]) -> None:
        print(f"porządkuję KLASĘ {cls.__name__} po testach\n")

    def setup_method(self, method: Callable[[], None]) -> None:
        print(f"przygotowuję METODĘ {method.__name__}")

    def teardown_method(self, method: Callable[[], None]) -> None:
        print(f"porządkuję METODĘ {method.__name__} po testach")


class TestClass1(BaseTest):
    def test_method_1(self) -> None:
        print("WYKONUJĘ METODĘ 1-1")

    def test_method_2(self) -> None:
        print("WYKONUJĘ METODĘ 1-2")


class TestClass2(BaseTest):
    def test_method_1(self) -> None:
        print("WYKONUJĘ METODĘ 2-1")

    def test_method_2(self) -> None:
        print("WYKONUJĘ METODĘ 2-2")
