
# Studium przypadku do rozdziału 9., Łańcuchy, serializacja i ścieżki do plików

## Serializacja

```
>>> from model import TrainingKnownSample
>>> s1 = TrainingKnownSample(
...     sepal_length=5.1, sepal_width=3.5, petal_length=1.4, petal_width=0.2, species="Iris-setosa")
>>> serialized = repr(s1)
>>> serialized
"TrainingKnownSample(sepal_length=5.1, sepal_width=3.5, petal_length=1.4, petal_width=0.2, species='Iris-setosa', )"
>>> s2 = eval(serialized)
>>> s1 == s2
True
>>> id(s1) == id(s2)
False


```

## Wbudowane narzędzia serializacji

## Projekty formatu danych CSV

### Wczytywanie danych CSV w formie słowników

```
>>> from model import CSVIrisReader
>>> from pathlib import Path
>>> test_data = Path.cwd().parent/"bezdekIris.data"
>>> rdr = CSVIrisReader(test_data)
>>> samples = list(rdr.data_iter())
>>> len(samples)
150
>>> samples[0]
{'sepal_length': '5.1', 'sepal_width': '3.5', 'petal_length': '1.4', 'petal_width': '0.2', 'species': 'Iris-setosa'}


```

```
>>> from model import TrainingData
>>> training_data = TrainingData("besdekIris")
>>> rdr = CSVIrisReader(test_data)
>>> training_data.load(rdr.data_iter())


```

### Wczytywanie danych CSV

### Różne rodzaje CSV

## Serializacja danych JSON

### Format JSON z danymi rozdzielanymi znakami nowego wiersza

### Walidacja danych JSON

## Format YAML

