from __future__ import annotations


class Contact:
    all_contacts: List["Contact"] = []

    def __init__(self, name: str, email: str) -> None:
        self.name = name
        self.email = email
        Contact.all_contacts.append(self)

    def __repr__(self) -> str:
        return (
            f"{self.__class__.__name__}(" 
            f"{self.name!r}, {self.email!r}" 
            f")"
        )

class Supplier(Contact):
    def order(self, order: "Order") -> None:
        print(
            "W tym miejscu prawdziwy system wysyłałby "
            f"zamówienie '{order}' do '{self.name}'"
        )
        
class Order:
    pass

class Friend(Contact):
    def __init__(self, name: str, email: str, phone: str) -> None:
        super().__init__(name, email)
        self.phone = phone

class Protocol:
    pass


class Emailable(Protocol):
    email: str
  
  
class MailSender(Emailable):
    def send_mail(self, message: str) -> None:
        print(f"Wysyłam wiadomość e-mail do {self.email=}")
        # Implementacja logiki wysyłania wiadomości
        
class EmailableContact(Contact, MailSender):
    pass

class AddressHolder:
    def __init__(self, street: str, city: str, state: str, code: str) -> None:
        self.street = street
        self.city = city
        self.state = state
        self.code = code