
# Studium przypadku dla rozdziału 3., Kiedy obiekty są do siebie podobne

## Widok logiczny

## Wzorzec projektowy Strategia

```python

>>> from math import isclose
>>> from model import TrainingKnownSample, UnknownSample, Chebyshev

>>> s1 = TrainingKnownSample(
...     sepal_length=5.1, sepal_width=3.5, petal_length=1.4, petal_width=0.2, species="Iris-setosa")
>>> u = UnknownSample(**{"sepal_length": 7.9, "sepal_width": 3.2, "petal_length": 4.7, "petal_width": 1.4})

>>> algorithm = Chebyshev()
>>> isclose(3.3, algorithm.distance(s1, u))
True

```

## Rozwiązanie Milinkowskiego

```python

>>> from math import isclose
>>> from model import TrainingKnownSample, UnknownSample, Euclidean

>>> s1 = TrainingKnownSample(
...     sepal_length=5.1, sepal_width=3.5, petal_length=1.4, petal_width=0.2, species="Iris-setosa")
>>> u = UnknownSample(**{"sepal_length": 7.9, "sepal_width": 3.2, "petal_length": 4.7, "petal_width": 1.4})

>>> algorithm = Euclidean()
>>> isclose(4.50111097, algorithm.distance(s1, u))
True

```

## Jeszcze jeden przykład

## Inna wersja Strategii

```python

>>> from model import TrainingKnownSample, UnknownSample, Minkowski_2

>>> class CD(Minkowski_2):
...     m = 1
...     reduction = max

>>> class MD(Minkowski_2):
...     m = 1
...     reduction = sum

>>> class ED(Minkowski_2):
...     m = 2
...     reduction = sum

```

## Podpowiedzi typów dla klasy Minkowski_2

