"""
Programowanie obiektowe w Pythonie 3

Rozdział 2., Obiekty w Pythonie
"""
from __future__ import annotations
from typing import Optional, Any


class Database:
    """Implementacja obsługi bazy danych"""

    def __init__(self, connection: Optional[str] = None) -> None:
        """Tworzy połączenie z bazą danych"""
        self.connection = connection

    def fetch(self, key: str) -> dict[str, Any]:
        return {"key": key}


db: Optional[Database] = None


def initialize_database(connection: Optional[str] = None) -> None:
    global db
    db = Database(connection)
    # print(f"Zainicjowano {db!r} z użyciem {connection!r}")


def get_database(connection: Optional[str] = None) -> Database:
    global db
    if not db:
        db = Database(connection)
        # print(f"Zainicjowano {db!r} z użyciem {connection!r}")
    return db


class Query:
    """Miejsce, w którym można umieścić bardziej złożony obiekt Query."""

    def __init__(self, database: Database, collection: str) -> None:
        """Tworzy zapytanie do bazy danych"""
        pass
