"""
Programowanie obiektowe w Pythonie 3

Rozdział 14., Współbieżność
"""
import asyncio
import random


async def random_sleep(counter: float) -> None:
    delay = random.random() * 5
    print(f"Zadanie {counter} zasypia na {delay:.2f} sekund")
    await asyncio.sleep(delay)
    print(f"Zadanie {counter} budzi się odświeżone")


async def sleepers(how_many: int = 5) -> None:
    print(f"Tworzę {how_many} zadań")
    tasks = [asyncio.create_task(random_sleep(i)) for i in range(how_many)]
    print(f"Oczekuję na {how_many} zadań")
    await asyncio.gather(*tasks)


if __name__ == "__main__":
    asyncio.run(sleepers(5))
    print("Wszystkie śpiochy obudzone!")
