"""
Programowanie obiektowe w Pythonie 3

Rozdział 10., Wzorzec Iterator
"""
from typing import Iterable, Iterator


class CapitalIterable(Iterable[str]):
    def __init__(self, string: str) -> None:
        self.string = string

    def __iter__(self) -> Iterator[str]:
        return CapitalIterator(self.string)


class CapitalIterator(Iterator[str]):
    def __init__(self, string: str) -> None:
        self.words = [w.capitalize() for w in string.split()]
        self.index = 0

    def __next__(self) -> str:
        if self.index == len(self.words):
            raise StopIteration()

        word = self.words[self.index]
        self.index += 1
        return word

    # def __iter__(self) -> Iterator[str]:
    #     return self


test_iterable = """
>>> iterable = CapitalIterable('szybki rudy lis przeskoczył leniwego psa')
>>> iterator = iter(iterable)
>>> while True:
...     try:
...         print(next(iterator))
...     except StopIteration:
...         break
...     
Szybki
Rudy
Lis
Przeskoczył
Leniwego
Psa

>>> for i in iterable:
...     print(i)
...     
Szybki
Rudy
Lis
Przeskoczył
Leniwego
Psa

>>> iterator = iter(iterable)
>>> for i in iter(iterator):
...     print(i)
...
Szybki
Rudy
Lis
Przeskoczył
Leniwego
Psa

"""


__test__ = {name: case for name, case in globals().items() if name.startswith("test_")}
