"""
Programowanie obiektowe w Pythonie 3

Rozdział 4., Oczekując nieoczekiwanego
"""


def exception_demo() -> None:
  
    some_exceptions = [ValueError, TypeError, IndexError, None]

    for choice in some_exceptions:
        try:
            print(f"\nZgłaszam wyjątek {choice}")
            if choice:
                raise choice("Wyjątek")
            else:
                print("Nie zgłoszono żadnego wyjątku")
        except ValueError:
            print("Przechwyciłem wyjątek ValueError")
        except TypeError:
            print("Przechwyciłem wyjątek TypeError")
        except Exception as e:
            print(f"Przechwyciłem jakiś inny wyjątek: {e.__class__.__name__}")
        else:
            print("Ten kod jest wykonywany, jeśli nie zgłoszono wyjątku")
        finally:
            print("To kod porządkujący, który jest wykonywany zawsze")


test_exception_demo = """
>>> exception_demo()
<BLANKLINE>
Zgłaszam wyjątek <class 'ValueError'>
Przechwyciłem wyjątek ValueError
To kod porządkujący, który jest wykonywany zawsze
<BLANKLINE>
Zgłaszam wyjątek <class 'TypeError'>
Przechwyciłem wyjątek TypeError
To kod porządkujący, który jest wykonywany zawsze
<BLANKLINE>
Zgłaszam wyjątek <class 'IndexError'>
Przechwyciłem jakiś inny wyjątek: IndexError
To kod porządkujący, który jest wykonywany zawsze
<BLANKLINE>
Zgłaszam wyjątek None
Nie zgłoszono żadnego wyjątku
Ten kod jest wykonywany jeśli nie zgłoszono wyjątku
To kod porządkujący, który jest wykonywany zawsze

"""

__test__ = {name: case for name, case in globals().items() if name.startswith("test_")}


if __name__ == "__main__":
    exception_demo()

