"""
Programowanie obiektowe w Pythonie 3

Rozdział 6., Abstrakcyjne klasy bazowe i przeciążanie operatorów
"""
from pytest import *  # type: ignore[import]
from debugging_help import DebuggingOnly

def test_happy_path(capfd):
    with DebuggingOnly():
        print("To zadziałało")
        print("Nawet całkiem dobrze")

    print("Milczenie jest złotem")

    out, err = capfd.readouterr()
    assert out == "Milczenie jest złotem\n"

def test_exception_path(capfd):
    with raises(AssertionError) as ex:
        with DebuggingOnly():
            print("To jest bardzo pomocne")
            print("I to również")
            assert False, "Z tego względu"

    out, err = capfd.readouterr()
    assert out == """--EX-->AssertionError('Z tego względu\\nassert False')
       To jest bardzo pomocne
       I to również
"""
