"""
Programowanie obiektowe w Pythonie 3

Rozdział 4., Oczekując nieoczekiwanego
"""
from typing import List


class EvenOnly(List[int]):
    def append(self, value: int) -> None:
        if not isinstance(value, int):
            raise TypeError("Można dodawać wyłącznie liczby całkowite")
        if value % 2 != 0:
            raise ValueError("Można dodawać wyłącznie liczby parzyste")
        super().append(value)


test_even_only = """
>>> e = EvenOnly()
>>> e.append("a string")
Traceback (most recent call last):
  File "<stdin>", line 1, in <module>
  File "even_integers.py", line 7, in add
    raise TypeError("Można dodawać wyłącznie liczby całkowite")
TypeError: Można dodawać wyłącznie liczby całkowite

>>> e.append(3)
Traceback (most recent call last):
  File "<stdin>", line 1, in <module>
  File "even_integers.py", line 9, in add
    raise ValueError("Można dodawać wyłącznie liczby parzyste")
ValueError: Można dodawać wyłącznie liczby parzyste
>>> e.append(2)
"""

test_even_only_missing_methods = """
By klasa była kompletna, trzeba by zadbać by także te metody nie działały.
>>> e = EvenOnly([1, 2, 3])
>>> e.extend([2, 3, 4])
>>> e[0] = 3
>>> e.insert(0, 5)
>>> e
[5, 3, 2, 3, 2, 3, 4]
"""

from typing import NoReturn

def never_returns() -> NoReturn:
    print("Mam zamiar zaraz zgłosić wyjątek")
    raise Exception("Ten wyjątek zawsze zostanie zgłoszony")
    print("Ten wiersz nigdy nie zostanie wykonany")
    return "Nigdy nie zwrócę tej wartości"


test_never_returns = """
>>> never_returns()
Traceback (most recent call last):
...
Exception: Ten wyjątek zawsze zostanie zgłoszony

"""


def call_exceptor() -> None:
    print("Tu się zaczyna call_exceptor...")
    never_returns()
    print("zgłoszono wyjątek...")
    print("...więc te wiersze nie zostaną wykonane")


test_call_exceptor = """
>>> call_exceptor()
Traceback (most recent call last):
...
Exception: Ten wyjątek zawsze zostanie zgłoszony

"""


def handler() -> None:
    try:
        never_returns()
        print("Ten wiersz nigdy nie zostanie wykonany")
    except Exception as ex:
        print(f"Przechwyciłem wyjątek: {ex!r}")
    print("Wiersz wykonywany po przechwyceniu wyjątku")


test_handler = """
>>> handler()
Mam zamiar zaraz zgłosić wyjątek
Przechwyciłem wyjątek: Exception('Ten wyjątek zawsze zostanie zgłoszony')
Wiersz wykonywany po przechwyceniu wyjątku

"""

from typing import Union


def funny_division(divisor: float) -> Union[str, float]:
    try:
        return 100 / divisor
    except ZeroDivisionError:
        return "Dzielenie przez zero nie jest dobrym pomysłem!"


test_funny_division = """
>>> print(funny_division(0))
Dzielenie przez zero nie jest dobrym pomysłem!
>>> print(funny_division(50.0))
2.0
>>> print(funny_division("siema!"))
Traceback (most recent call last):
...
TypeError: unsupported operand type(s) for /: 'int' and 'str'

"""


def funnier_division(divisor: int) -> Union[str, float]:
    try:
        if divisor == 13:
            raise ValueError("13 to pechowa liczba")
        return 100 / divisor
    except (ZeroDivisionError, TypeError):
        return "Wpisz liczbę różną od zera!"


test_funnier_division = """
>>> for val in (0, "hello", 50.0, 13):
...     print(f"Sprawdzamy {val!r}:", end=" ")
...     print(funnier_division(val))
Traceback (most recent call last):
...
ValueError: 13 to pechowa liczba

"""


def funniest_division(divisor: int) -> Union[str, float]:
    try:
        if divisor == 13:
            raise ValueError("13 to pechowa liczba")
        return 100 / divisor
    except ZeroDivisionError:
        return "Wpisz liczbę różną od zera!"
    except TypeError:
        return "Wpisz wartość liczbową"
    except ValueError:
        print("Nie, nie... tylko nie 13!")
        raise


test_funniest_division = """
>>> for val in (0, "hello", 50.0, 13):
...     print(f"Sprawdzamy {val!r}:", end=" ")
...     print(funniest_division(val))
Traceback (most recent call last):
...
ValueError: 13 to pechowa liczba

"""


__test__ = {name: case for name, case in globals().items() if name.startswith("test_")}
