"""
Programowanie obiektowe w Pythonie 3

Rozdział 14., Współbieżność

Ile czasu trwa "prosty" zapis?
"""
import timeit
from textwrap import dedent
import random
import string
from pathlib import Path

repeat_count = 5_000_000
for message_size in (128, 256, 512, 1024):
    log_message = ''.join(random.choice(string.printable) for _ in range(message_size))
    t = timeit.timeit(
        stmt="some_file.write(log_message)",
        setup=dedent(
            """
            some_path = Path("temp_file.log")
            some_file = some_path.open('w')
            """
        ),
        number=repeat_count,
        globals=globals()
    )
    print(f"Czas trwania zapisu {message_size} wierszy znaków wyniósł: {t/repeat_count*1_000_000:.6f} μs")
