"""
Programowanie obiektowe w Pythonie 3

Rozdział 6., Abstrakcyjne klasy bazowe i przeciążanie operatorów
"""
import logging
from pytest import *
import random
from dice import D6L

@fixture
def fixed_random():
    random.seed(42)

def test_dice_logger(caplog, fixed_random):
    caplog.set_level(logging.INFO)
    d6l = D6L()
    assert d6l.face == 6
    assert caplog.messages == [
        'wyrzucona liczba: 6'
    ]
    assert D6L.roll.__doc__ == "Dokumentacja klasy D6L"
