var express = require("express");
var http = require("http");

var app = express();
var server = http.createServer(app);
var io = require("socket.io").listen(server, {
    "polling duration": 10
});

app.set("views", __dirname + "/views");
app.set("view engine", "ejs");

app.use(express.bodyParser());
app.use(express.cookieParser());
app.use(express.session({ secret: "gameserversession" }));
app.use(app.router);
app.use(express.static(__dirname + "/public"));
app.use(express.errorHandler());

app.get("/", function(req, res) {
    res.sendfile(__dirname + "/public/index.html"); 
});

server.listen(80);

var maxUserId = 0;
var users = {};

io.sockets.on("connection", function (socket) {
    var userId = addUser(socket);

    socket.on("disconnect", function () {
        socket.broadcast.emit("user-left", users[userId]);
        delete users[userId];
    });
});

/** 
* Rejestruje uytkownika na serwerze, informujc pozostaych klientw o zaistniaej sytuacji. Ponadto
* nowo zarejestrowany uytkownik otrzymuje list wszystkich aktywnych klientw. 
* @param socket obiekt gniazda podczonego klienta 
* @returns ID nowo utworzonego uytkownika  
*/ 

function addUser(socket) {
    var userId = maxUserId++;
    var userName = "Uytkownik " + userId;

    var user = {id: userId, name: userName, status: "ready"};
    users[userId] = user;

    socket.emit("info", "Nawizano poczenie");
    socket.emit("user-list", { users: users });
    socket.broadcast.emit("user-joined", user);
    return userId;
}