/** 
 * Implementacja klasy InputHandler dla przeglądarki stacjonarnej, oparta o zdarzenia myszy
 */ 

function MouseInputHandler(element) {
    InputHandlerBase.call(this, element);

    // Musimy skorzystać z dodatkowej właściwości, aby śledzić stan wciśnięcia przycisku myszy. 
    this._mouseDown = false;
    this._attachDomListeners();
}

extend(MouseInputHandler, InputHandlerBase);

_p = MouseInputHandler.prototype;

/** 
 * Przypisz słuchaczy do zdarzeń DOM typu mouseXXX 
 */ 
_p._attachDomListeners = function() {
    var el = this._element;
    el.addEventListener("mousedown", this._onDownDomEvent.bind(this), false);
    el.addEventListener("mouseup", this._onUpDomEvent.bind(this), false);
    el.addEventListener("mousemove", this._onMoveDomEvent.bind(this));
    el.addEventListener("mouseout", this._onMouseOut.bind(this));
};

/** 
 * Ta metoda (podobnie jak następna) jest przesłonięta, ponieważ musimy
 * śledzić stan myszy. Moglibyśmy też wykonać tę operację w odrębnym słuchaczu zdarzeń.
 */ 

_p._onDownDomEvent = function(e) {
    this._mouseDown = true;
    InputHandlerBase.prototype._onDownDomEvent.call(this, e);
};

_p._onUpDomEvent = function(e) {
    this._mouseDown = false;
    InputHandlerBase.prototype._onUpDomEvent.call(this, e);
};

/** 
 * Przetwarzamy zdarzenie move, pod warunkiem że przycisk myszy jest wciśnięty; 
 * W przeciwnym razie zdarzenie DOM jest ignorowane. 
 */ 

_p._onMoveDomEvent = function(e) {
    if (this._mouseDown) {
        InputHandlerBase.prototype._onMoveDomEvent.call(this, e);
    }
};

_p._onMouseOut = function() {
    this._mouseDown = false;
};