function LobbyUsersList(listElement, clickCallback) {
    this._users = {};
    this._listElement = listElement;
    this._clickCallback = clickCallback;
}

var _p = LobbyUsersList.prototype;

_p.add = function(userId, username, status) {
    // Jeśli użytkownik jest już dostępny, zaktualizuj informacje na jego temat
    if (this._users[userId]) {
        this.setStatus(userId, status);
        this.setName(userId, username);
    } else {
        // W przeciwnym razie utwórz element i dołącz go do drzewa DOM
        var el = this._users[userId] = this._getUserListElement(userId, username, status);
        this._listElement.appendChild(el);

        // W momencie kliknięcia elementu listy pobierz informacje na temat użytkownika i wykonaj wywołanie zwrotne
        el.addEventListener("click", (function(e) {
            var userId = el.getAttribute("data-userid");
            var userName = el.innerHTML;
            var state = el.className;
            this._clickCallback.call(this, userId, userName, status);
        }).bind(this));
    }
};

_p.setStatus = function(userId, status) {
    // Ustawienie statusu oznacza zmianę nazwy klasy 
    if (this._users[userId]) {
        this._users[userId].className = status;
    }
};

_p.setName = function(userId, name) {
    // Nazwa jest umieszczana w atrybucie innerHTML
    if (this._users[userId]) {
        this._users[userId].innerHTML = name;
    }
};

_p.remove = function(userId) {
    if (this._users[userId]) {
        this._listElement.removeChild(this._users[userId]);
        delete this._users[userId];
    }
};

_p._getUserListElement = function(userId, userName, status) {
    // Utwórz nowy element (listy) i ustaw wartości  
    var el = document.createElement("li");
    el.className = status;
    
    // Zapisujemy własne dane powiązane z tym elementem, korzystając z atrybutów danych HTML5.
    // http://dev.w3.org/html5/spec/Overview.html#embedding-custom-non-visible-data-with-the-data-attributes
    el.setAttribute("data-userid", userId);
    el.innerHTML = userName;
    return el;
};
