/**
 * Klasa bazowa dla wszystkich klas, które mają wywoływać zdarzenia.
 */
function EventEmitter() {
    this._listeners = {};
}

_p = EventEmitter.prototype;

/**
 * Rejestruje funkcję, która ma otrzymywać powiadomienia o zdarzeniach danego typu.
 * @param type Typ zdarzenia
 * @param listener Funkcja nasłuchująca do dodania
 */
_p.addListener = _p.on = function(type, listener) {
    if (typeof listener !== "function")
        throw "Listener must be a function";

    if (!this._listeners[type]) {
        this._listeners[type] = [];
    }

    this._listeners[type].push(listener);
};

/**
 * Wyrejestrowuje podanego słuchacza z podanego typu
 * @param type Typ zdarzenia
 * @param listener Funkcja nasłuchująca do usunięcia
 */
_p.removeListener = function(type, listener) {
    if (typeof listener !== "function")
        throw "Należy podać funkcję!";

    if (!this._listeners[type])
        return;

    var position = this._listeners[type].indexOf(listener);
    if (position != -1)
        this._listeners[type].splice(position, 1);
};

/**
 * Usuń wszystkie funkcje nasłuchujące dla danego typu zdarzenia.
 * Jeśli nie podano typu, usuń wszystkie funkcje.
 * @param type Typ zdarzenia (opcjonalnie)
 */
_p.removeAllListeners = function(type) {
    if (type) {
        this._listeners[type] = [];
    } else {
        this._listeners = {};
    }
};

/**
 * Informuje wszystkich słuchaczy zapisanych do danego typu o zdarzeniu
 * @param type Typ zdarzenia
 * @param event Obiekt zdarzenia
 */
_p.emit = function(type, event) {
    if (!(this._listeners[type] && this._listeners[type].length)) {
        return;
    }

    for (var i = 0; i < this._listeners[type].length; i++) {
        this._listeners[type][i].call(this, event);
    }
};