/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.api;

import org.apache.cordova.CordovaWebView;
import org.apache.cordova.api.CordovaInterface;
import org.apache.cordova.api.IPlugin;
import org.apache.cordova.api.Plugin;

public class PluginEntry {
    public String service = "";
    public String pluginClass = "";
    public IPlugin plugin = null;
    public boolean onload = false;

    public PluginEntry(String service, String pluginClass, boolean onload) {
        this.service = service;
        this.pluginClass = pluginClass;
        this.onload = onload;
    }

    public IPlugin createPlugin(CordovaWebView webView, CordovaInterface ctx) {
        if (this.plugin != null) {
            return this.plugin;
        }
        try {
            Class c = this.getClassByName(this.pluginClass);
            if (this.isCordovaPlugin(c)) {
                this.plugin = (IPlugin)c.newInstance();
                this.plugin.setContext(ctx);
                this.plugin.setView(webView);
                return this.plugin;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error adding plugin " + this.pluginClass + ".");
        }
        return null;
    }

    private Class getClassByName(String clazz) throws ClassNotFoundException {
        Class<?> c = null;
        if (clazz != null) {
            c = Class.forName(clazz);
        }
        return c;
    }

    private boolean isCordovaPlugin(Class c) {
        if (c != null) {
            return Plugin.class.isAssignableFrom(c) || IPlugin.class.isAssignableFrom(c);
        }
        return false;
    }
}

