/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import java.io.File;
import org.apache.cordova.api.Plugin;
import org.apache.cordova.api.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Storage
extends Plugin {
    private static final String ALTER = "alter";
    private static final String CREATE = "create";
    private static final String DROP = "drop";
    private static final String TRUNCATE = "truncate";
    SQLiteDatabase myDb = null;
    String path = null;
    String dbName = null;

    public PluginResult execute(String action, JSONArray args, String callbackId) {
        PluginResult.Status status = PluginResult.Status.OK;
        String result = "";
        try {
            if (action.equals("openDatabase")) {
                this.openDatabase(args.getString(0), args.getString(1), args.getString(2), args.getLong(3));
            } else if (action.equals("executeSql")) {
                String[] s = null;
                if (args.isNull(1)) {
                    s = new String[]{};
                } else {
                    JSONArray a = args.getJSONArray(1);
                    int len = a.length();
                    s = new String[len];
                    for (int i = 0; i < len; ++i) {
                        s[i] = a.getString(i);
                    }
                }
                this.executeSql(args.getString(0), s, args.getString(2));
            }
            return new PluginResult(status, result);
        }
        catch (JSONException e) {
            return new PluginResult(PluginResult.Status.JSON_EXCEPTION);
        }
    }

    public boolean isSynch(String action) {
        return true;
    }

    public void onDestroy() {
        if (this.myDb != null) {
            this.myDb.close();
            this.myDb = null;
        }
    }

    public void openDatabase(String db, String version, String display_name, long size) {
        if (this.myDb != null) {
            this.myDb.close();
        }
        if (this.path == null) {
            this.path = this.cordova.getActivity().getApplicationContext().getDir("database", 0).getPath();
        }
        this.dbName = this.path + File.pathSeparator + db + ".db";
        this.myDb = SQLiteDatabase.openOrCreateDatabase((String)this.dbName, null);
    }

    public void executeSql(String query, String[] params, String tx_id) {
        try {
            if (this.isDDL(query)) {
                this.myDb.execSQL(query);
                this.sendJavascript("cordova.require('cordova/plugin/android/storage').completeQuery('" + tx_id + "', '');");
            } else {
                Cursor myCursor = this.myDb.rawQuery(query, params);
                this.processResults(myCursor, tx_id);
                myCursor.close();
            }
        }
        catch (SQLiteException ex) {
            ex.printStackTrace();
            System.out.println("Storage.executeSql(): Error=" + ex.getMessage());
            this.sendJavascript("cordova.require('cordova/plugin/android/storage').failQuery('" + ex.getMessage() + "','" + tx_id + "');");
        }
    }

    private boolean isDDL(String query) {
        String cmd = query.toLowerCase();
        return cmd.startsWith(DROP) || cmd.startsWith(CREATE) || cmd.startsWith(ALTER) || cmd.startsWith(TRUNCATE);
    }

    public void processResults(Cursor cur, String tx_id) {
        String result = "[]";
        if (cur.moveToFirst()) {
            JSONArray fullresult = new JSONArray();
            String key = "";
            String value = "";
            int colCount = cur.getColumnCount();
            do {
                JSONObject row = new JSONObject();
                try {
                    for (int i = 0; i < colCount; ++i) {
                        key = cur.getColumnName(i);
                        value = cur.getString(i);
                        row.put(key, (Object)value);
                    }
                    fullresult.put((Object)row);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            } while (cur.moveToNext());
            result = fullresult.toString();
        }
        this.sendJavascript("cordova.require('cordova/plugin/android/storage').completeQuery('" + tx_id + "', " + result + ");");
    }
}

