/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import java.util.List;
import org.apache.cordova.api.CordovaInterface;
import org.apache.cordova.api.Plugin;
import org.apache.cordova.api.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AccelListener
extends Plugin
implements SensorEventListener {
    public static int STOPPED = 0;
    public static int STARTING = 1;
    public static int RUNNING = 2;
    public static int ERROR_FAILED_TO_START = 3;
    private float x = 0.0f;
    private float y = 0.0f;
    private float z = 0.0f;
    private long timestamp = 0L;
    private int status;
    private int accuracy = 0;
    private SensorManager sensorManager;
    private Sensor mSensor;
    private String callbackId;

    public AccelListener() {
        this.setStatus(STOPPED);
    }

    public void setContext(CordovaInterface cordova) {
        super.setContext(cordova);
        this.sensorManager = (SensorManager)cordova.getActivity().getSystemService("sensor");
    }

    public PluginResult execute(String action, JSONArray args, String callbackId) {
        PluginResult.Status status = PluginResult.Status.NO_RESULT;
        String message = "";
        PluginResult result = new PluginResult(status, message);
        result.setKeepCallback(true);
        if (action.equals("start")) {
            this.callbackId = callbackId;
            if (this.status != RUNNING) {
                this.start();
            }
        } else if (action.equals("stop")) {
            if (this.status == RUNNING) {
                this.stop();
            }
        } else {
            return new PluginResult(PluginResult.Status.INVALID_ACTION);
        }
        return result;
    }

    public void onDestroy() {
        this.stop();
    }

    private int start() {
        if (this.status == RUNNING || this.status == STARTING) {
            return this.status;
        }
        this.setStatus(STARTING);
        List list = this.sensorManager.getSensorList(1);
        if (list == null || list.size() <= 0) {
            this.setStatus(ERROR_FAILED_TO_START);
            this.fail(ERROR_FAILED_TO_START, "No sensors found to register accelerometer listening to.");
            return this.status;
        }
        this.mSensor = (Sensor)list.get(0);
        this.sensorManager.registerListener((SensorEventListener)this, this.mSensor, 2);
        this.setStatus(STARTING);
        long timeout = 2000L;
        while (this.status == STARTING && timeout > 0L) {
            timeout -= 100L;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (timeout == 0L) {
            this.setStatus(ERROR_FAILED_TO_START);
            this.fail(ERROR_FAILED_TO_START, "Accelerometer could not be started.");
        }
        return this.status;
    }

    private void stop() {
        if (this.status != STOPPED) {
            this.sensorManager.unregisterListener((SensorEventListener)this);
        }
        this.setStatus(STOPPED);
        this.accuracy = 0;
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
        if (sensor.getType() != 1) {
            return;
        }
        if (this.status == STOPPED) {
            return;
        }
        this.accuracy = accuracy;
    }

    public void onSensorChanged(SensorEvent event) {
        if (event.sensor.getType() != 1) {
            return;
        }
        if (this.status == STOPPED) {
            return;
        }
        this.setStatus(RUNNING);
        if (this.accuracy >= 2) {
            this.timestamp = System.currentTimeMillis();
            this.x = event.values[0];
            this.y = event.values[1];
            this.z = event.values[2];
            this.win();
        }
    }

    private void fail(int code, String message) {
        JSONObject errorObj = new JSONObject();
        try {
            errorObj.put("code", code);
            errorObj.put("message", (Object)message);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        PluginResult err = new PluginResult(PluginResult.Status.ERROR, errorObj);
        err.setKeepCallback(true);
        this.error(err, this.callbackId);
    }

    private void win() {
        PluginResult result = new PluginResult(PluginResult.Status.OK, this.getAccelerationJSON());
        result.setKeepCallback(true);
        this.success(result, this.callbackId);
    }

    private void setStatus(int status) {
        this.status = status;
    }

    private JSONObject getAccelerationJSON() {
        JSONObject r = new JSONObject();
        try {
            r.put("x", (double)this.x);
            r.put("y", (double)this.y);
            r.put("z", (double)this.z);
            r.put("timestamp", this.timestamp);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return r;
    }
}

