/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.content.res.AssetFileDescriptor;
import android.media.MediaPlayer;
import android.media.MediaRecorder;
import android.os.Environment;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.cordova.AudioHandler;

public class AudioPlayer
implements MediaPlayer.OnCompletionListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnErrorListener {
    private static final String LOG_TAG = "AudioPlayer";
    private static int MEDIA_STATE = 1;
    private static int MEDIA_DURATION = 2;
    private static int MEDIA_POSITION = 3;
    private static int MEDIA_ERROR = 9;
    private static int MEDIA_ERR_NONE_ACTIVE = 0;
    private static int MEDIA_ERR_ABORTED = 1;
    private static int MEDIA_ERR_NETWORK = 2;
    private static int MEDIA_ERR_DECODE = 3;
    private static int MEDIA_ERR_NONE_SUPPORTED = 4;
    private AudioHandler handler;
    private String id;
    private MODE mode = MODE.NONE;
    private STATE state = STATE.MEDIA_NONE;
    private String audioFile = null;
    private float duration = -1.0f;
    private MediaRecorder recorder = null;
    private String tempFile = null;
    private MediaPlayer player = null;
    private boolean prepareOnly = true;
    private int seekOnPrepared = 0;

    public AudioPlayer(AudioHandler handler, String id, String file) {
        this.handler = handler;
        this.id = id;
        this.audioFile = file;
        this.tempFile = Environment.getExternalStorageState().equals("mounted") ? Environment.getExternalStorageDirectory().getAbsolutePath() + "/tmprecording.mp3" : "/data/data/" + handler.cordova.getActivity().getPackageName() + "/cache/tmprecording.mp3";
    }

    public void destroy() {
        if (this.player != null) {
            if (this.state == STATE.MEDIA_RUNNING || this.state == STATE.MEDIA_PAUSED) {
                this.player.stop();
                this.setState(STATE.MEDIA_STOPPED);
            }
            this.player.release();
            this.player = null;
        }
        if (this.recorder != null) {
            this.stopRecording();
            this.recorder.release();
            this.recorder = null;
        }
    }

    public void startRecording(String file) {
        switch (this.mode) {
            case PLAY: {
                Log.d((String)LOG_TAG, (String)"AudioPlayer Error: Can't record in play mode.");
                this.handler.sendJavascript("cordova.require('cordova/plugin/Media').onStatus('" + this.id + "', " + MEDIA_ERROR + ", { \"code\":" + MEDIA_ERR_ABORTED + "});");
                break;
            }
            case NONE: {
                if (this.recorder != null) break;
                this.audioFile = file;
                this.recorder = new MediaRecorder();
                this.recorder.setAudioSource(1);
                this.recorder.setOutputFormat(0);
                this.recorder.setAudioEncoder(0);
                this.recorder.setOutputFile(this.tempFile);
                try {
                    this.recorder.prepare();
                    this.recorder.start();
                    this.setState(STATE.MEDIA_RUNNING);
                    return;
                }
                catch (IllegalStateException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.handler.sendJavascript("cordova.require('cordova/plugin/Media').onStatus('" + this.id + "', " + MEDIA_ERROR + ", { \"code\":" + MEDIA_ERR_ABORTED + "});");
                break;
            }
            case RECORD: {
                Log.d((String)LOG_TAG, (String)"AudioPlayer Error: Already recording.");
                this.handler.sendJavascript("cordova.require('cordova/plugin/Media').onStatus('" + this.id + "', " + MEDIA_ERROR + ", { \"code\":" + MEDIA_ERR_ABORTED + "});");
            }
        }
    }

    public void moveFile(String file) {
        File f = new File(this.tempFile);
        if (Environment.getExternalStorageState().equals("mounted")) {
            f.renameTo(new File(Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + file));
        } else {
            f.renameTo(new File("/data/data/" + this.handler.cordova.getActivity().getPackageName() + "/cache/" + file));
        }
    }

    public void stopRecording() {
        if (this.recorder != null) {
            try {
                if (this.state == STATE.MEDIA_RUNNING) {
                    this.recorder.stop();
                    this.setState(STATE.MEDIA_STOPPED);
                }
                this.moveFile(this.audioFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void startPlaying(String file) {
        if (this.readyPlayer(file)) {
            this.player.start();
            this.setState(STATE.MEDIA_RUNNING);
        } else {
            this.prepareOnly = false;
        }
    }

    public void seekToPlaying(int milliseconds) {
        if (this.readyPlayer(this.audioFile)) {
            this.player.seekTo(milliseconds);
            Log.d((String)LOG_TAG, (String)"Send a onStatus update for the new seek");
            this.handler.sendJavascript("cordova.require('cordova/plugin/Media').onStatus('" + this.id + "', " + MEDIA_POSITION + ", " + (float)milliseconds / 1000.0f + ");");
        } else {
            this.seekOnPrepared = milliseconds;
        }
    }

    public void pausePlaying() {
        if (this.state == STATE.MEDIA_RUNNING) {
            this.player.pause();
            this.setState(STATE.MEDIA_PAUSED);
        } else {
            Log.d((String)LOG_TAG, (String)("AudioPlayer Error: pausePlaying() called during invalid state: " + this.state.ordinal()));
            this.handler.sendJavascript("cordova.require('cordova/plugin/Media').onStatus('" + this.id + "', " + MEDIA_ERROR + ", { \"code\":" + MEDIA_ERR_NONE_ACTIVE + "});");
        }
    }

    public void stopPlaying() {
        if (this.state == STATE.MEDIA_RUNNING || this.state == STATE.MEDIA_PAUSED) {
            this.player.stop();
            this.setState(STATE.MEDIA_STOPPED);
        } else {
            Log.d((String)LOG_TAG, (String)("AudioPlayer Error: stopPlaying() called during invalid state: " + this.state.ordinal()));
            this.handler.sendJavascript("cordova.require('cordova/plugin/Media').onStatus('" + this.id + "', " + MEDIA_ERROR + ", { \"code\":" + MEDIA_ERR_NONE_ACTIVE + "});");
        }
    }

    public void onCompletion(MediaPlayer player) {
        this.setState(STATE.MEDIA_STOPPED);
    }

    public long getCurrentPosition() {
        if (this.state == STATE.MEDIA_RUNNING || this.state == STATE.MEDIA_PAUSED) {
            int curPos = this.player.getCurrentPosition();
            this.handler.sendJavascript("cordova.require('cordova/plugin/Media').onStatus('" + this.id + "', " + MEDIA_POSITION + ", " + (float)curPos / 1000.0f + ");");
            return curPos;
        }
        return -1L;
    }

    public boolean isStreaming(String file) {
        return file.contains("http://") || file.contains("https://");
    }

    public float getDuration(String file) {
        if (this.recorder != null) {
            return -2.0f;
        }
        if (this.player != null) {
            return this.duration;
        }
        this.prepareOnly = true;
        this.startPlaying(file);
        return this.duration;
    }

    public void onPrepared(MediaPlayer player) {
        this.player.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
        if (!this.prepareOnly) {
            this.player.start();
            this.setState(STATE.MEDIA_RUNNING);
        } else {
            this.setState(STATE.MEDIA_STARTING);
        }
        this.duration = this.getDurationInSeconds();
        this.prepareOnly = true;
        this.seekToPlaying(this.seekOnPrepared);
        this.seekOnPrepared = 0;
        this.handler.sendJavascript("cordova.require('cordova/plugin/Media').onStatus('" + this.id + "', " + MEDIA_DURATION + "," + this.duration + ");");
    }

    private float getDurationInSeconds() {
        return (float)this.player.getDuration() / 1000.0f;
    }

    public boolean onError(MediaPlayer player, int arg1, int arg2) {
        Log.d((String)LOG_TAG, (String)("AudioPlayer.onError(" + arg1 + ", " + arg2 + ")"));
        this.player.stop();
        this.player.release();
        this.handler.sendJavascript("cordova.require('cordova/plugin/Media').onStatus('" + this.id + "', { \"code\":" + arg1 + "});");
        return false;
    }

    private void setState(STATE state) {
        if (this.state != state) {
            this.handler.sendJavascript("cordova.require('cordova/plugin/Media').onStatus('" + this.id + "', " + MEDIA_STATE + ", " + this.state.ordinal() + ");");
        }
        this.state = state;
    }

    private void setMode(MODE mode) {
        if (this.mode != mode) {
            // empty if block
        }
        this.mode = mode;
    }

    public int getState() {
        return this.state.ordinal();
    }

    public void setVolume(float volume) {
        this.player.setVolume(volume, volume);
    }

    private boolean playMode() {
        switch (this.mode) {
            case NONE: {
                this.setMode(MODE.PLAY);
                break;
            }
            case PLAY: {
                break;
            }
            case RECORD: {
                Log.d((String)LOG_TAG, (String)"AudioPlayer Error: Can't play in record mode.");
                this.handler.sendJavascript("cordova.require('cordova/plugin/Media').onStatus('" + this.id + "', " + MEDIA_ERROR + ", { \"code\":" + MEDIA_ERR_ABORTED + "});");
                return false;
            }
        }
        return true;
    }

    private boolean readyPlayer(String file) {
        if (this.playMode()) {
            switch (this.state) {
                case MEDIA_NONE: {
                    if (this.player == null) {
                        this.player = new MediaPlayer();
                    }
                    try {
                        this.loadAudioFile(file);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return false;
                }
                case MEDIA_LOADING: {
                    Log.d((String)LOG_TAG, (String)("AudioPlayer Loading: startPlaying() called during media preparation: " + STATE.MEDIA_STARTING.ordinal()));
                    this.prepareOnly = false;
                    return false;
                }
                case MEDIA_STARTING: 
                case MEDIA_RUNNING: 
                case MEDIA_PAUSED: {
                    return true;
                }
                case MEDIA_STOPPED: {
                    if (this.audioFile.compareTo(file) == 0) {
                        this.player.seekTo(0);
                        this.player.pause();
                        return true;
                    }
                    this.player.reset();
                    try {
                        this.loadAudioFile(file);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.handler.sendJavascript("cordova.require('cordova/plugin/Media').onStatus('" + this.id + "', " + MEDIA_ERROR + ", { \"code\":" + MEDIA_ERR_ABORTED + "});");
                    }
                    return false;
                }
            }
            Log.d((String)LOG_TAG, (String)("AudioPlayer Error: startPlaying() called during invalid state: " + (Object)((Object)this.state)));
            this.handler.sendJavascript("cordova.require('cordova/plugin/Media').onStatus('" + this.id + "', " + MEDIA_ERROR + ", { \"code\":" + MEDIA_ERR_ABORTED + "});");
        }
        return false;
    }

    private void loadAudioFile(String file) throws IllegalArgumentException, SecurityException, IllegalStateException, IOException {
        if (this.isStreaming(file)) {
            this.player.setDataSource(file);
            this.player.setAudioStreamType(3);
            this.setMode(MODE.PLAY);
            this.setState(STATE.MEDIA_STARTING);
            this.player.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.player.prepareAsync();
        } else {
            if (file.startsWith("/android_asset/")) {
                String f = file.substring(15);
                AssetFileDescriptor fd = this.handler.ctx.getActivity().getAssets().openFd(f);
                this.player.setDataSource(fd.getFileDescriptor(), fd.getStartOffset(), fd.getLength());
            } else {
                File fp = new File(file);
                if (fp.exists()) {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    this.player.setDataSource(fileInputStream.getFD());
                } else {
                    this.player.setDataSource("/sdcard/" + file);
                }
            }
            this.setState(STATE.MEDIA_STARTING);
            this.player.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.player.prepare();
            this.duration = this.getDurationInSeconds();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum STATE {
        MEDIA_NONE,
        MEDIA_LOADING,
        MEDIA_STARTING,
        MEDIA_RUNNING,
        MEDIA_PAUSED,
        MEDIA_STOPPED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MODE {
        NONE,
        PLAY,
        RECORD;

    }
}

