package main

import (
	"database/sql"
	"flag"
	"fmt"
	"net/http"

	_ "github.com/go-sql-driver/mysql"
)

var (
	user   = flag.String("użytkownik", "", "Nazwa użytkownika bazy danych")
	passwd = flag.String("hasło", "", "Hasło do bazy danych")
	db     = flag.String("baza danych", "", "Baza danych, z którą się łączysz")
	query  = flag.String("zapytanie", "", "Zapytanie testowe")
	addr   = flag.String("adres", "localhost:8080", "Adres, na którym nasłuchujesz")
)

// Podstawowe użycie:
//   db-check --query="SELECT * from moja-super-tabela" \
//            --user=bdburns \
//            --passwd="chciałbyś"
//
func main() {
	flag.Parse()
	db, err := sql.Open("localhost", fmt.Sprintf("%s:%s@/%s", *user, *passwd, *db))
	if err != nil {
		fmt.Printf("Błąd otwarcia bazy danych: %v", err)
	}

	// Prosta procedura obsługi WWW, która uruchamia zapytanie
	http.HandleFunc("", func(res http.ResponseWriter, req *http.Request) {
		_, err := db.Exec(*query)
		if err != nil {
			res.WriteHeader(http.StatusInternalServerError)
			res.Write([]byte(err.Error()))
			return
		}
		res.WriteHeader(http.StatusOK)
		res.Write([]byte("OK"))
		return
	})
	// Uruchomienie serwera
	http.ListenAndServe(*addr, nil)
}
