use std::net::TcpListener;
use std::io;
use std::thread::spawn;

/// Nieskończona pętla oczekująca na połączenia. Dla każdego z nich
/// tworzony jest nowy wątek
fn echo_main(addr: &str) -> io::Result<()> {
    let listener = TcpListener::bind(addr)?;
    println!("listening on {}", addr);
    loop {
        // Oczekiwanie na połączenie
        let (mut stream, addr) = listener.accept()?;
        println!("connection received from {}", addr);

        // Nowy wątek klienta
        let mut write_stream = stream.try_clone()?;
        spawn(move || {
            // Echo, czyli odsyłamy odebrane wartości ze strumienia `stream`
            io::copy(&mut stream, &mut write_stream)
                .expect("error in client thread: ");
            println!("connection closed");
        });
    }
}

fn main() {
    echo_main("127.0.0.1:17007").expect("error: ");
}
