//! Struktura biologiczna wyższego poziomu.
//!
//! Zawsze symulujemy przykład wszystkich interakcji chemicznych w komórce,
//! ale symulacja wszystkiego w ten sposób jest po prostu zbyt
//! skomplikowana. Dlatego wydzielamy struktury danych wyższego poziomu:
//! korzeń, liście, inne paprocie. Kiedy symulujemy warunki fizyczne (światło, powietrze
//! prądy, grawitacja) zawsze używamy tych struktur zamiast
//! milionów komórek, które zazwyczaj reprezentują. Mówiąc inaczej,
//! struktury te wzmacniają się, gdy umierają, dzięki czemu martwe liście mają wagę,
//! mogą rzucać cień itd.

// w plant_structures/mod.rs
pub mod roots;
pub mod stems;
pub mod leaves;

pub use self::leaves::Leaf;
pub use self::roots::Root;

use self::roots::RootSet;
use self::stems::StemSet;

pub enum FernType {
    Fiddlehead
}

pub struct Fern {
    pub roots: RootSet,
    pub stems: StemSet
}

impl Fern {
    pub fn new(_type: FernType) -> Fern {
        Fern {
            roots: vec![],
            stems: vec![stems::Stem { furled: true }]
        }
    }

    pub fn is_furled(&self) -> bool { !self.is_fully_unfurled() }

    pub fn is_fully_unfurled(&self) -> bool {
        self.stems.iter().all(|s| !s.furled)
    }
}
