# Przykłady do książki _Programowanie w języku Rust_

Niniejsze repozytorium zawiera pełny kod źródłowy większości przykładowych
projektów opisanych w książce “Programowanie w języku Rust”, 
której autorami są Jim Blandy i Jason Orendorff.

Każdy katalog zawiera oddzielny projekt Rust wraz z plikiem projektu Cargo.toml.
Po wejściu do katalogu możemy za pomocą polecenia `cargo build`
zbudować projekt lub wołając `cargo test` uruchomić jego test.
Projekty, które są programami można też uruchomić poleceniem `cargo run`.

Przykłady zawarte w tym katalogu i jego podkatalogach są udostępnione
na licencji MIT. Aby uzyskać szczegółowe informacje,
patrz [LICENCJA-MIT] (LICENCJA-MIT).

## Rozdział 2: Pierwsze spotkanie z Rustem

- Katalog `gcd` zawiera uruchamiany z wiersza poleceń program do
  obliczania największego wspólnego dzielnika podanych liczb.

- Katalog `iron-gcd` zawiera kod prostej aplikacji internetowej,
  zaimplementowanej z użyciem frameworku [`iron`], która również
  oblicza największy wspólny dzielnik podanych liczb.

  [`iron`]: https://crates.io/crates/iron

- Program do rysowania zbioru Mandelbrota znajduje się we własnym,
  osobnym repozytorium dostępnym pod adresem
  `https://github.com/ProgrammingRust/mandelbrot`. To repozytorium
  zawiera kilka gałęzi, każda z nich jest przykładem innej strategii implementacji.
  Gałąź `single-threaded` przechowuje kod wersji jednowątkowej, a gałąź `bands`
  zawiera wersję wielowątkową. W rozdziale 19, “Programowanie współbieżne”, 
  prezentujemy jeszcze kilka innych, alternatywnych rozwiązań, które dostępne
  są w kolejnych gałęziach; szczegóły w pliku [README.md][mandel-readme]
  dostępnym w repozytorium.

## Chapter 8: Paczki i moduły

- W rzeczywistości nie napisaliśmy symulatora paproci. Proszę przyjąć nasze
  szczere przeprosiny za to niewinne oszustwo. Ale szkielet modułów i definicji,
  które pokazujemy w książce, znajduje się w katalogu `fern_sim`.  

## Chapter 9: Struktury

- W katalogu `queue` znajdziemy bibliotekę, która definiuje typ `Queue`,
  reprezentujący kolejkę wartości typu `char`.

- Katalog `generic-queue` zawiera kod generycznej wersji kolejki `Queue`.

## Chapter 10: Typy wyliczeniowe i wzorce

- Katalog `binary-tree` przechowuje kod źródłowy typu `BinaryTree`,
  który pojawia się w podrozdziałach “Generyczne typy wyliczeniowe”
  i “Wypełnianie drzewa binarnego”.

## Chapter 12: Przeciążanie operatorów

- W katalogu `complex` znajduje się definicja typu `Complex`, który
  używany jest w całym rozdziale.

- Katalog `interval` zawiera typ `Interval`, który implementuje
  zestaw metod `std::cmp::PartialOrd`.  

## Chapter 14: Domknięcia

- Katalog `basic-router` zawiera definicję typu `BasicRouter`, który użyty
  jest jako przykład opisany w podrozdziale “Funkcje zwrotne”.

## Chapter 15: Iteratory

- Katalog `binary-tree` zawiera implementację zestawu metod `Iterator` dla typu
  `BinaryTree` pierwotnie zdefiniowanego w rozdziale “Typy wyliczeniowe i wzorce”.

## Chapter 17: Tekst i łańcuchy znaków

- Katalog `complex` zawiera implementację zestawu metod `std::fmt::Display` dla
  typu liczb zespolonych. Opisujemy to w punkcie “Formatowanie własnych typów”.  

## Chapter 18: Operacje wejścia/wyjścia

- Katalog `grep` zawiera prosty program zbliżony w działaniu do standardowego
  polecenia grep, piszemy o nim w punkcie “Pobieranie tekstu”.

- Katalog `copy` zawiera program do kopiowania drzew katalogów opisany w punkcie
  “Odczyt zawartości katalogu”, w tym dodatki pokazane w następnym punkcie,
  czyli “Funkcje bezpośrednio związane z platformą”.

- Katalog `echo-server` zawiera prostą usługę sieciową opisaną w punkcie “Obsługa sieci”.

- Katalog `http-get` zawiera program wołany z wiersza poleceń, który
  używa paczki `reqwest` do wysyłania żądań HTTP.  

## Chapter 19: Programowanie współbieżne

- Wyszukiwarka używana w całej książce jako działający przykład ma swoje własne
  repozytorium pod adresem `https://github.com/ProgrammingRust/fingertips`.

- Program do rysowania zbioru Mandelbrota, wspomniany w punkcie
  “Zbiór Mandelbrota raz jeszcze”, znajduje się we własnym,
  osobnym repozytorium dostępnym pod adresem
  `https://github.com/ProgrammingRust/mandelbrot`. 
  To repozytorium zawiera kilka gałęzi, każda z nich jest przykładem innej strategii implementacji.
  Szczegóły tutaj: [README.md][mandel-readme].

[mandel-readme]: https://github.com/ProgrammingRust/mandelbrot/blob/master/README.md

## Chapter 20: Makra

- Katalog `json-macro` zawiera definicję makra `json!`, tworzymy je w podrozdziale “Makro json!”.  

## Chapter 21: Kod niebezpieczny

- Katalog `ascii` zawiera definicję typu `Ascii`, użyty jest on jako przykład
  w podrozdziałach “Bloki unsafe” i “Funkcje unsafe”.  

- Katalog `ref-with-flag` zawiera definicję typu `RefWithFlag` opisanego w podrozdziale
  “Wskaźniki niechronione”.

- Katalog `gap-buffer` zawiera definicję typu `GapBuffer`, piszemy o nim w podrozdziale
  “Wskaźniki niechronione” ilustrując w ten sposób arytmetykę wskaźników `std::ptr::read` oraz
  `std::ptr::write`.

- Katalogi `libgit2-rs` i `libgit2-rs-safe` zawierają dwie wersje programu,
  który używa obcego interfejsu do wywoływania funkcji z biblioteki `libgit2` języka C.
  Wersja w `libgit2-rs` jest napisana jako pojedynczy blok niebezpiecznego kodu, wersja
  w `libgit2-rs-safe` implementuje bezpieczny interfejs Rust dla tej samej funkcjonalności,
  wykorzystując dla poprawnego działania system typów Rust, egzekwując reguły libgit2.
  
  Zauważ, że oba rozwiązania wymagają posiadania kopii `libgit2` w swoim systemie.
  Rozdział zawiera szczegółowe instrukcje dotyczące budowania poprawnej wersji dla systemu
  Linux, macOS i Microsoft Windows.  
