#![allow(dead_code, unused_variables)]

//! Reprodukcja  paproci.

use cells::{Cell, Gene};

/// Komórka wytworzona przez dorosłą paproć
/// jest przenoszona przez wiatr w ramach cyklu życia paproci
/// Zarodnik wyrasta na osobny organizm, o średnicy 5 mm, i wytwarza zygotę,
/// z której wyrasta nowa paproć (płeć roślin jest skomplikowana)
pub struct Spore {
    size: f64
}

/// Symuluj wytwarzanie zarodników w wyniku mejozy
pub fn produce_spore(factory: &mut Sporangium) -> Spore {
    Spore { size: 1.0 }
}

/// Wyodrębnia geny z konkretnego zarodnika
pub(crate) fn genes(spore: &Spore) -> Vec<Gene> {
    todo!()
}

/// Wymieszaj geny, aby przygotować się na mejozę (część interfazy)
fn recombine(parent: &mut Cell) {
    todo!()
}

pub struct Sporangium;

mod cells {
    //! Symulacja biologicznych komórek, najniższy uwzgledniany poziom.

    pub struct Cell {
        x: f64,
        y: f64
    }

    impl Cell {
        pub fn distance_from_origin(&self) -> f64 {
            f64::hypot(self.x, self.y)
        }
    }

    pub struct Gene;
}
