mod back_of_house {
    pub struct Breakfast {
        pub toast: String,
        seasonal_fruit: String,
    }

    impl Breakfast {
        pub fn summer(toast: &str) -> Breakfast {
            Breakfast {
                toast: String::from(toast),
                seasonal_fruit: String::from("brzoskwinie"),
            }
        }
    }
}

pub fn eat_at_restaurant() {
    // Zamawiamy niadanie z tostami ytnimi latem
    let mut meal = back_of_house::Breakfast::summer("ytni");
    // Zmieniamy zdanie w kwestii rodzaju pieczywa
    meal.toast = String::from("przenny");
    println!("Poprosz tost {}", meal.toast);

    // Jeli usuniemy komentarz przez ponisz lini, ona si nie skompiluje;
    // nie moemy sprawdzi ani zmieni owocw sezonowych podawanych do niadania
    // meal.seasonal_fruit = String::from("borwki");
}
