fn first_word(s: &String) -> usize {
    let bytes = s.as_bytes();

    for (i, &item) in bytes.iter().enumerate() {
        if item == b' ' {
            return i;
        }
    }

    s.len()
}

// ANCHOR: here
fn main() {
    let mut s = String::from("witaj wiecie");

    let word = first_word(&s); // word otrzyma warto 5

    s.clear(); // To oprnia String, ktry staje si rwny ""

    // Tutaj word wci ma warto 5, ale nie ma adnego acucha znakw, z ktrym
    // moglibymy w sposb znaczcy uy wartoci 5. Zmienna word jest teraz cakowicie niepoprawna!
}
// ANCHOR_END: here
