use rand::Rng;
use std::cmp::Ordering;
use std::io;

fn main() {
    println!("Zgadnij liczb!");

    let secret_number = rand::thread_rng().gen_range(1..=100);

    println!("Sekretna liczba to: {secret_number}");

    loop {
        println!("Wpisz swj typ.");

        let mut guess = String::new();

        // ANCHOR: here
        // --fragment pominity--

        io::stdin()
            .read_line(&mut guess)
            .expect("Nie udao si odczyta linii");

        // ANCHOR: ch19
        let guess: u32 = match guess.trim().parse() {
            Ok(num) => num,
            Err(_) => continue,
        };
        // ANCHOR_END: ch19

        println!("Twj typ to: {guess}");

        // --fragment pominity--
        // ANCHOR_END: here

        match guess.cmp(&secret_number) {
            Ordering::Less => println!("Za maa liczba!"),
            Ordering::Greater => println!("Za dua liczba!"),
            Ordering::Equal => {
                println!("Zgade!");
                break;
            }
        }
    }
}
