use rand::Rng;
use std::cmp::Ordering;
use std::io;

// ANCHOR: here
pub struct Guess {
    value: i32,
}

impl Guess {
    pub fn new(value: i32) -> Guess {
        if value < 1 || value > 100 {
            panic!("Guess musi mie warto z przedziau od 1 do 100, otrzymano warto {}.", value);
        }

        Guess { value }
    }

    pub fn value(&self) -> i32 {
        self.value
    }
}
// ANCHOR_END: here

fn main() {
    println!("Zgadnij liczb!");

    let secret_number = rand::thread_rng().gen_range(1..=100);

    loop {
        println!("Wpisz swj typ.");

        let mut guess = String::new();

        io::stdin()
            .read_line(&mut guess)
            .expect("Nie udao si odczyta linii");

        let guess: i32 = match guess.trim().parse() {
            Ok(num) => num,
            Err(_) => continue,
        };

        let guess = Guess::new(guess);

        match guess.value().cmp(&secret_number) {
            Ordering::Less => println!("Za maa liczba!"),
            Ordering::Greater => println!("Za dua liczba!"),
            Ordering::Equal => {
                println!("Zgade!");
                break;
            }
        }
    }
}
