use proc_macro::TokenStream;
use quote::quote;
use syn;

#[proc_macro_derive(HelloMacro)]
pub fn hello_macro_derive(input: TokenStream) -> TokenStream {
    // Konstruuje reprezentacj kodu Rusta jako drzewa skadni,
    // ktr moemy manipulowa
    let ast = syn::parse(input).unwrap();

    // Buduje implementacj cechy
    impl_hello_macro(&ast)
}

fn impl_hello_macro(ast: &syn::DeriveInput) -> TokenStream {
    let name = &ast.ident;
    let gen = quote! {
        impl HelloMacro for #name {
            fn hello_macro() {
                println!("Witaj, Makro! Nazywam si {}!", stringify!(#name));
            }
        }
    };
    gen.into()
}
