enum Message {
    Quit,
    Move { x: i32, y: i32 },
    Write(String),
    ChangeColor(i32, i32, i32),
}

fn main() {
    let msg = Message::ChangeColor(0, 160, 255);

    match msg {
        Message::Quit => {
            println!("Wariant Quit nie ma danych do destrukturyzacji.");
        }
        Message::Move { x, y } => {
            println!("Przesu w kierunku x {x} i w kierunku y {y}");
        }
        Message::Write(text) => {
            println!("Wiadomo tekstowa: {text}");
        }
        Message::ChangeColor(r, g, b) => {
            println!("Zmie kolor na czerwony {r}, zielony {g} i niebieski {b}",)
        }
    }
}
