use std::env;
use std::fs;

fn main() {
    let args: Vec<String> = env::args().collect();

    let config = Config::new(&args);

    println!("Wyszukiwanie {}", config.query);
    println!("W pliku {}", config.file_path);

    let contents = fs::read_to_string(config.file_path)
        .expect("Odczyt pliku powinien by moliwy");

    println!("Z tekstem:\n{contents}");
}

struct Config {
    query: String,
    file_path: String,
}

impl Config {
    // ANCHOR: here
    // --fragment pominity--
    fn new(args: &[String]) -> Config {
        if args.len() < 3 {
            panic!("za maa liczba argumentw");
        }
        // --fragment pominity--
        // ANCHOR_END: here

        let query = args[1].clone();
        let file_path = args[2].clone();

        Config { query, file_path }
    }
}
