﻿/* Cylon Eyes
   Half-stepping turns the next light on for a little bit,
   makes the pattern visually smoother, improves overall
   cylonity.
*/
// ------- Preambuła -------- //
#include <avr/io.h>                        /* Definiuje piny, porty, itd. */
#include <util/delay.h>                     /* Funkcje marnujące czas */
#define DELAYTIME 85    /* milisekundy, 50-75 sprawdza się w większosci przypadków */
int main(void) {
  // -------- Inicjalizacja --------- //
  uint8_t i;
  DDRB = 0xff;                  /* Rejestr DDRB
                                   wszystkie piny jako wyjście */
  // ------ Pętla zdarzeń ------ //
  while (1) {                                              /* pętla główna */
    for (i = 0; i < 7; i++) {                   /* i odlicza od 0 do 6 */
      PORTB |= (1 << i);                              /* włącz diodę i */
      _delay_ms(DELAYTIME);                                    /* czekaj */
      PORTB |= (1 << (i + 1));                 /* włącz następną diodę */
      _delay_ms(DELAYTIME / 2);
      PORTB &= ~(1 << i);                            /* wyłącz diodę i */
    }
    for (i = 7; i > 0; i--) {                   /* i odlicza od 7 do 1 */
      PORTB |= (1 << i);
      _delay_ms(DELAYTIME);
      PORTB |= (1 << (i - 1));                 /* włącz następną diodę */
      _delay_ms(DELAYTIME / 2);
      PORTB &= ~(1 << i);                            /* wyłącz diodę i */
    }
  }                                                  /* Koniec pętli zdarzeń */
  return (0);
}                                                           /* koniec funkcji main */
