﻿// ------- Preambuła -------- //
#include <avr/io.h>
#include <util/delay.h>
#define DELAY     100                                            /* ms */
static inline uint8_t LFSR8_step(uint8_t random);
static inline uint16_t LFSR16(uint16_t random);
int main(void) {
  // -------- Inicjalizacja --------- //
  DDRB = 0xff;                                   /* wszystkie diody jako wyjście */
  uint16_t random = 123;           /* nie można inicjować zerem, trzeba użyć innej wartości */
  // ------ Pętla zdarzeń ------ //
  while (1) {
                                                 /* Wyświetlanie i wyjście */
    random = LFSR16(random);
    PORTB = (random >> 8);
    _delay_ms(DELAY);
  }                                                  /* Koniec pętli zdarzeń */
  return (0);
}

// ----------------- Funkcje LFSR ---------------- //
inline uint8_t LFSR8_step(uint8_t random) {
  /*
     Pobiera liczbę 8-bitową i jeden krok w tablicy LFSR.
     [3, 4, 5, 7] to wartości wybierane spośród 8 bitów w całym cyklu,
     przed jego powtórzeniem.
     Jeżeli naprawdę chcesz działać losowo, to musisz użyć innego algorytmu.
     Co więcej, to doskonale pokazuje jak "przewidywalna" jest ta 
     "pseudolosowa" sekwencja.
     Zauważ, że nie jest to najskuteczniejsza metoda zakodowania tego działania,
     ale chodzi tu głównie o naukę i szybkść działania
     ponieważ kompilator świetnie sobie z tym radzi.
   */
  uint8_t tap1, tap2, tap3, tap4;
  uint8_t newBit;
  tap1 = 1 & (random >> 3);
  tap2 = 1 & (random >> 4);
  tap3 = 1 & (random >> 5);
  tap4 = 1 & (random >> 7);
  newBit = tap1 ^ tap2 ^ tap3 ^ tap4;
  random = ((random << 1) | newBit);
  return (random);
}

inline uint16_t LFSR16(uint16_t random) {
  // 3, 12, 14, 15 to maksymalne wartości przy 16 bitach.
  uint16_t tap1, tap2, tap3, tap4;
  uint16_t newBit;
  tap1 = 1 & (random >> 3);
  tap2 = 1 & (random >> 12);
  tap3 = 1 & (random >> 14);
  tap4 = 1 & (random >> 15);
  newBit = tap1 ^ tap2 ^ tap3 ^ tap4;
  random = ((random << 1) | newBit);
  return (random);
}
