﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using Microsoft.WindowsMobile.Samples.Location;


namespace GPS
{
    public partial class Form1 : Form
    {
        Gps gps = new Gps();

        string opisStanuGPS = "";
        string polozenieGPS = "";

        public Form1()
        {
            InitializeComponent();            
        }

        delegate void ZmienTekst(Control kontrolka, string tekst);
        void ZmienTekstKontrolki(Control kontrolka, string tekst)
        {
            kontrolka.Text = tekst;
        }

        void gps_DeviceStateChanged(object sender, DeviceStateChangedEventArgs args)
        {
            opisStanuGPS =
                "Urządzenie GPS: " + args.DeviceState.FriendlyName.ToString() + "\r\n" +
                "Stan urządzenia GPS: " + args.DeviceState.DeviceState.ToString() + "\r\n" +
                "Stan usługi GPS: " + args.DeviceState.ServiceState.ToString() + "\r\n\r\n";
            
            //textBox1.Text = opisStanuGPS + polozenieGPS; //to nie dziala
            //0
            //BeginInvoke(new ZmienTekst(ZmienTekstKontrolki), textBox1, opisStanuGPS + polozenieGPS);
            //Action<Control, string> a = ((Control kontrolka, string tekst) => kontrolka.Text = tekst);
            //1
            //Action<string> a = ((string tekst) => {textBox1.Text = tekst;});
            //BeginInvoke(a, opisStanuGPS + polozenieGPS);            
            //2
            //Action a = (() => {textBox1.Text = opisStanuGPS + polozenieGPS;});
            //BeginInvoke(a);
            //3
            BeginInvoke((Action)(() => { textBox1.Text = opisStanuGPS + polozenieGPS; }));
        }

        void gps_LocationChanged(object sender, LocationChangedEventArgs args)
        {
            GpsPosition p = args.Position;
            polozenieGPS = "";
            if (p.SatellitesInViewCountValid)
                polozenieGPS += "Widoczne satelity: " + p.SatellitesInViewCount + "\r\n";
            if (p.LatitudeValid) polozenieGPS += "Szerokość g.: " + p.Latitude + " °\r\n";
            if (p.LongitudeValid) polozenieGPS += "Długość g.: " + p.Longitude + " °\r\n";
            if (p.HeadingValid) polozenieGPS += "Kierunek: " + p.Heading + " °\r\n";
            if (p.SeaLevelAltitudeValid)
                polozenieGPS += "Wysokość n.p.m.: " + p.SeaLevelAltitude + " ft\r\n";
            if (p.SpeedValid) polozenieGPS += "Prędkość: " + p.Speed + " MPH\r\n"; ;
            if (p.TimeValid) polozenieGPS += "Czas: " + p.Time;

            BeginInvoke((Action)(() => { textBox1.Text = opisStanuGPS + polozenieGPS; }));
        }

        private void menuItem1_Click(object sender, EventArgs e)
        {
            if (!gps.Opened)
            {
                gps.Open();
                gps.DeviceStateChanged += new DeviceStateChangedEventHandler(gps_DeviceStateChanged);
                gps.LocationChanged += new LocationChangedEventHandler(gps_LocationChanged);

                if (!gps.Opened) textBox1.Text = "Nie udało się włączyć modułu GPS";
                else textBox1.Text = "Moduł GPS został włączony";
            }
            else
            {
                gps.DeviceStateChanged -= gps_DeviceStateChanged;
                gps.LocationChanged -= gps_LocationChanged;
                gps.Close();                

                if (gps.Opened) textBox1.Text = "Nie udało się wyłączyć modułu GPS";
                else textBox1.Text = "Moduł GPS został wyłączony";
            }
            menuItem1.Text = gps.Opened ? "Wyłącz GPS" : "Włącz GPS";
        }

        private void menuItem2_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void Form1_Closed(object sender, EventArgs e)
        {
            if (gps.Opened) menuItem1_Click(null, null);
        }
    }
}