﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using Microsoft.WindowsMobile;
using Microsoft.WindowsMobile.Status;
using Microsoft.WindowsMobile.Forms;

using System.IO;

namespace Aparat
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            menuItem1.Enabled = (SystemState.CameraPresent && SystemState.CameraEnabled);
        }

        /*
        private void menuItem1_Click(object sender, EventArgs e)
        {
            CameraCaptureDialog ccd = new CameraCaptureDialog();
            ccd.Mode = CameraCaptureMode.Still;
            ccd.StillQuality = CameraCaptureStillQuality.Normal;
            ccd.Title = "Zrób zdjęcie...";
            if (ccd.ShowDialog() == DialogResult.OK)
            {
                Bitmap zdjecie = new Bitmap(ccd.FileName);
                float proporcjaObrazu = (float)zdjecie.Width / zdjecie.Height;
                pictureBox1.Height = (int)(pictureBox1.Width * proporcjaObrazu);
                pictureBox1.Image = zdjecie;

                MessageBox.Show(ccd.FileName + " (" + zdjecie.Width + "x" + zdjecie.Height + ")");
            }
        }
        */

        private void menuItem1_Click(object sender, EventArgs e)
        {
            CameraCaptureDialog ccd = new CameraCaptureDialog();
            ccd.Mode = CameraCaptureMode.Still;
            ccd.StillQuality = CameraCaptureStillQuality.Normal;            
            ccd.Title = "Zrób zdjęcie...";

            ccd.InitialDirectory = @"\Temp";
            string[] listaPlikow=Directory.GetFiles(ccd.InitialDirectory);

            ccd.ShowDialog();

            string[] nowaListaPlikow = Directory.GetFiles(ccd.InitialDirectory);
            if (nowaListaPlikow.Count() > listaPlikow.Count())
            {
                var uporzadkowanaListaPlikow = from string sciezkaDoPliku in nowaListaPlikow
                                               orderby File.GetCreationTime(sciezkaDoPliku)
                                               select sciezkaDoPliku;
                string sciezkaDoZdjecia = uporzadkowanaListaPlikow.Last();

                Bitmap zdjecie = new Bitmap(sciezkaDoZdjecia);
                float proporcjaObrazu = (float)zdjecie.Width / zdjecie.Height;
                pictureBox1.Height = (int)(pictureBox1.Width * proporcjaObrazu);
                pictureBox1.Image = zdjecie;

                MessageBox.Show(sciezkaDoZdjecia + " (" + zdjecie.Width + "x" + zdjecie.Height + ")");
            }
        }

        private void menuItem2_Click(object sender, EventArgs e)
        {
            SelectPictureDialog spd = new SelectPictureDialog();
            spd.CameraAccess = false;
            spd.Title = "Wybierz obraz...";
            if (spd.ShowDialog() == DialogResult.OK)
            {
                Bitmap zdjecie = new Bitmap(spd.FileName);
                float proporcjaObrazu = (float)zdjecie.Width / zdjecie.Height;
                pictureBox1.Height = (int)(pictureBox1.Width * proporcjaObrazu);
                pictureBox1.Image = zdjecie;

                MessageBox.Show(spd.FileName + " (" + zdjecie.Width + "x" + zdjecie.Height + ")");
            }
        }

    }
}