﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using Microsoft.WindowsCE.Forms;

namespace Kontrolki
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            try
            {
                hardwareButton1.AssociatedControl = this;
                hardwareButton1.HardwareKey = HardwareKeys.ApplicationKey1; //klawisz Menu z prawej strony obudowy Samsung Omnia
            }
            catch(Exception exc)
            {
                MessageBox.Show("Nie można skonfigurować kontrolki HardwareButton (być może urządzenie nie ma odpowiedniego przycisku)");
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            inputPanel1.Enabled = !inputPanel1.Enabled;

            Rectangle polozenie = inputPanel1.Bounds;
            string s = "Położenie panelu:\n";            
            s += "górna krawędź: " + polozenie.Top + "\n";
            s += "wysokość: " + polozenie.Height + "\n";
            s += "procent wys. okna: " + 100 * polozenie.Height / this.Height + "\n";
            s += "procent wys. ekranu: " + 100 * polozenie.Height / Screen.PrimaryScreen.Bounds.Height + "\n";
            s += "szerokość: " + polozenie.Width + "\n";
            s += "lewa krawędź: " + polozenie.Left + "\n";
            MessageBox.Show(s);

            polozenie = inputPanel1.VisibleDesktop;
            s = "Widoczny pulpit:\n";            
            s += "górna krawędź: " + polozenie.Top + "\n";
            s += "wysokość: " + polozenie.Height + "\n";
            s += "procent wys. okna: " + 100 * polozenie.Height / this.Height + "\n";
            s += "procent wys. ekranu: " + 100 * polozenie.Height / Screen.PrimaryScreen.Bounds.Height + "\n";            
            s += "szerokość: " + polozenie.Width + "\n";
            s += "lewa krawędź: " + polozenie.Left + "\n";
            MessageBox.Show(s);
            
            InputMethod metodaWprowadzaniaTekstu = inputPanel1.CurrentInputMethod;
            s = "Metoda wprowadzania tekstu: " + metodaWprowadzaniaTekstu.Name + "\n";
            s += "Dostępne metody: ";
            foreach (InputMethod metoda in inputPanel1.InputMethods)
                s += metoda.Name + "; ";
            s += "\n";            
            
            MessageBox.Show(s);
        }

        private void textBox1_GotFocus(object sender, EventArgs e)
        {
            inputPanel1.Enabled = true;
        }

        private void textBox1_LostFocus(object sender, EventArgs e)
        {
            inputPanel1.Enabled = false;
        }

        private void button2_Click(object sender, EventArgs e)
        {            
            notification1.Critical = checkBox2.Checked;
            notification1.InitialDuration = (int)numericUpDown1.Value;
            //notification1.Icon = this.Icon; //????               

            if (!checkBox3.Checked) notification1.Text = textBox1.Text;
            else
            {
                StringBuilder html = new StringBuilder();
                html.Append("<html><body>");
                html.Append("Wpisz tekst do przekazania:<br>");
                html.Append("<form method=\'GET\' action=notify>");
                html.Append("<input name=\"txt\" value=\"przykładowy tekst\"><p>");
                html.Append("<input type='submit'>");
                html.Append("<input type=button name='cmd:2' value='Cancel'>");
                html.Append("</body></html>");
                notification1.Text = html.ToString();
            }

            notification1.Visible = true;                
        }

        private void notification1_BalloonChanged(object sender, BalloonChangedEventArgs e)
        {
            Color tmp = button2.BackColor;
            button2.BackColor = button2.ForeColor;
            button2.ForeColor = tmp;
        }

        private void notification1_ResponseSubmitted(object sender, ResponseSubmittedEventArgs e)
        {
            textBox1.Text = e.Response;
        }

        private void button3_Click(object sender, EventArgs e)
        {
            MessageBox.Show("Przycisk button3");
        }

        private void Form1_KeyDown(object sender, KeyEventArgs e)
        {
            label1.Text = "Wciśnięto " + e.KeyCode.ToString() + " " + e.KeyValue.ToString();            

            switch ((HardwareKeys)e.KeyCode)
            {
                case HardwareKeys.ApplicationKey1:
                    label1.Text = "Wciśnięto ApplicationKey1";
                    break;
                case HardwareKeys.ApplicationKey2:
                    label1.Text = "Wciśnięto ApplicationKey2";
                    break;                
            }
        }

        private void Form1_KeyUp(object sender, KeyEventArgs e)
        {
            label1.Text = "Zwolniono " + e.KeyCode.ToString() + " " + e.KeyValue.ToString();

            switch ((HardwareKeys)e.KeyCode)
            {
                case HardwareKeys.ApplicationKey1:
                    label1.Text = "Zwolniono ApplicationKey1";
                    break;
                case HardwareKeys.ApplicationKey2:
                    label1.Text = "Zwolniono ApplicationKey2";
                    break;
            }
        }
    }
}