public class FH {
    /* Funkcje hiperboliczne */
	   
    static double sinh(double x) {/* sinus hiperboliczny */
        double ex = Math.exp(x);
	    return (ex-1/ex)/2;
    }
       
    static double cosh(double x) {/* cosinus hiperboliczny */
	    double ex = Math.exp(x);
	    return (ex+1/ex)/2;
    }
       
    static double tanh(double x) {/* tangens hiperboliczny */
	    double ex1 = Math.exp(x);
	    double ex2 = 1/ex1;
	    return (ex1-ex2)/(ex1+ex2);
    }
       
    static double coth(double x) {/* cotangens hiperboliczny */
	    double ex1 = Math.exp(x);
	    double ex2 = 1/ex1;
	    return (ex1+ex2)/(ex1-ex2);
    }
       
    static double sech(double x) {/* secans hiperboliczny */
        double ex = Math.exp(x);
	    return 2/(ex+1/ex);
    }
       
    static double csch(double x) {/* cosecans hiperboliczny */
	    double ex = Math.exp(x);
	    return 2/(ex-1/ex);
    }
       
    /* Funkcje odwrotne do funkcji hiperbolicznych */
       
    static double arsinh(double x) {/* area sinus hiperboliczny */
	    return Math.log(x+Math.sqrt(x*x+1));
    }
       
    static double arcosh(double x) {/* area cosinus hiperboliczny */
	    return Math.log(x+Math.sqrt(x*x-1));
    }
       
    static double artanh(double x) {/* area tangens hiperboliczny */
	    return Math.log((1+x)/(1-x))/2;
    }
       
    static double arcoth(double x) {/* area cotangens hiperboliczny */
	    return Math.log((x+1)/(x-1))/2;
    }
       
    static double arsech(double x) {/* area secans hiperboliczny */
	       return Math.log(Math.sqrt(1/(x*x)-1)+1/x);
    }
       
    static double arcsch(double x) {/* area cosecans hiperboliczny */
	    return Math.log(Math.sqrt(1+1/(x*x))+1/x);
    }
}