public class Z28_23 {
	public static double[][] product (double[][] x, double[][] y) {
		if (x[0].length != y.length)
		    throw new ArithmeticException("Niezgodne wymiary macierzy");
		double[][] tmp = new double[x.length][y[0].length];
		for(int i = 0; i < x.length; ++i) 
            for(int j = 0; j < y[0].length; ++j)
                for(int k = 0; k < y.length; ++k)
                    tmp[i][j] += x[i][k]*y[k][j];
        return tmp;
	}
	private static double[][] inverse(double[][] x) {
		if (x.length != x[0].length)
		    throw new ArithmeticException("To nie jest macierz kwadratowa");
		int n = x.length;
		    
	    double[][] tmp = new double[n][n];
	    for(int i = 0; i < n; ++i)
	        for(int j = 0; j < n; ++j)
	            tmp[i][j] = x[i][j];
	            
	    double[][] I = new double[n][n];
	    for(int i = 0; i < n; ++i)
	        I[i][i] = 1.0;
	                  
	    for(int i = 0; i < n; ++i)     
	        for(int j = 0; j < n; ++j)  {
		        if (tmp[i][i] != 0.0) {
			        if (j != i) {
		                double p = tmp[j][i]/tmp[i][i];
		                for(int k = 0; k < n; ++k) {
	                        tmp[j][k] -= tmp[i][k]*p;
	                        I[j][k] -= I[i][k]*p;
                        }
                    }
			        
		        } else {
                    for(int k = i+1; k < n; ++k) {
			            if (tmp[k][i] != 0.0) {
				            for(int m = 0; m < n; ++m) {
					            double temp = tmp[i][m];
					            tmp[i][m] = tmp[k][m];
					            tmp[k][m] = -temp;
					            temp = I[i][m];
					            I[i][m] = I[k][m];
					            I[k][m] = -temp;
				            }
				            break;
			            }    
		            }
                }
            }   
        for(int i = 0; i < n; ++i) 
            if (tmp[i][i] != 0.0) 
                for(int j = 0; j < n; ++j)
                    I[i][j] /= tmp[i][i];  
            else
                throw new ArithmeticException("Macierz odwrotna nie istnieje");   
	    return I;
    }
    	
    public static void main(String[] args) {
	    double[][] a = new double[5][5];
	    TDouble.setRandom(a, 10.0); 
	    System.out.println("Macierz A");
	    TDouble.printf("%8.2f", a);
	    double[][] b = inverse(a);
	    System.out.println("Macierz B");
	    TDouble.printf("%8.2f", b);
	    System.out.println("Sprawdzenie");
	    TDouble.printf("%8.2f", product(a, b));  
    }
}