/** Zadanie Z22.5 */
final class RN {
    protected final String r;
    protected final int d;
    private RN(String r, int d) {
        this.r = r; this.d = d;
    };
    static final RN[] rn = {new RN("M", 1000), new RN("CM", 900), 
        new RN("D", 500), new RN("CD", 400),  new RN("C", 100), 
        new RN("XC", 90), new RN("L", 50), new RN("XL", 40), 
        new RN("X", 10), new RN("IX", 9), new RN("V", 5), 
        new RN("IV", 4), new RN("I", 1)};
}

public class Z22_5 {
		        
	private static String decToRoman(int n) {
		StringBuilder tmp = new StringBuilder("");
		for(int i = 0; i<13; ++i) {
            while (n >= RN.rn[i].d) {
                n -= RN.rn[i].d;
                tmp.append(RN.rn[i].r);
            }
        } 
        return tmp.toString();           
	}
	private static int romanToDec(String s)  {
        int tmp = 0;
        int index = 0;  // indeks analizowanego znaku
        for (int i = 0; i < 13; i++) 
            while (s.startsWith(RN.rn[i].r, index)) {
                tmp += RN.rn[i].d;
                index += RN.rn[i].r.length();
            }        
        if (!s.equals(decToRoman(tmp)) || tmp > 3999)
            throw new ArithmeticException("Niewaciwa liczba rzymska: "+s); 
        return tmp;
    }
    
	public static void main(String args[]) {
		System.out.println("Odczytywanie liczb w systemie rzymskim");
		String[] test = {"XXVII", "CCXLV", "III", "MMMCMXCIX", "MXXIV"};
		for(String r: test) 
		    System.out.println(r+" = "+romanToDec(r)); 
    }
}
