public class Roman {
    private static final class RN {
        final String r;
        final int d;
        private RN(String r, int d) {
            this.r = r; this.d = d;
        };
        static final RN[] rn = {new RN("M", 1000), new RN("CM", 900), 
            new RN("D", 500), new RN("CD", 400),  new RN("C", 100), 
            new RN("XC", 90), new RN("L", 50), new RN("XL", 40), 
            new RN("X", 10), new RN("IX", 9), new RN("V", 5), 
            new RN("IV", 4), new RN("I", 1)};
        }
        
    private int n;
    
    public Roman(int n) {
	    if(n < 1 || n > 3999)
			throw new ArithmeticException("Liczba poza zakresem");
		else
			this.n = n;
    }

    public Roman(String s) {
	    this.n = romanToDec(s);;
    } 

    @Override public String toString() { 
        return decToRoman(this.n);
    }
    
    public static Roman valueOf(String s) {
	    return new Roman(s);
    }
    
    public static Roman valueOf(int n) {
	    return new Roman(n);
    }
    
    public int intValue() {
	    return n;
    }
    
    public static String decToRoman(int n) {
		StringBuilder tmp = new StringBuilder("");
		for(int i = 0; i<13; ++i) {
            while (n >= RN.rn[i].d) {
                n -= RN.rn[i].d;
                tmp.append(RN.rn[i].r);
            }
        } 
        return tmp.toString();           
	}
	
    public static int romanToDec(String s)  {
        int tmp = 0;
        int index = 0;  // indeks analizowanego znaku
        for (int i = 0; i < 13; i++) 
            while (s.startsWith(RN.rn[i].r, index)) {
                tmp += RN.rn[i].d;
                index += RN.rn[i].r.length();
            }        
        if (!s.equals(decToRoman(tmp)) || tmp > 3999)
            throw new ArithmeticException("Niewaciwa liczba rzymska: "+s); 
        return tmp;
    }
}