import java.util.Random;
import java.util.Arrays;
public class MyRandomArray {
    public static int[] rndArray(int n, int m) {
	    Random rnd = new Random();
	    int[] tmp = new int[n];
	    for(int i = 0; i < n; ++i) 
	        tmp[i] = rnd.nextInt(m);
	    return tmp;
    }
    
    public static int[] rndSortArray(int n, int m) {
	    Random rnd = new Random();
	    int[] tmp = new int[n];
	    for(int i = 0; i < n; ++i) 
	        tmp[i] = rnd.nextInt(m);
	    Arrays.sort(tmp);
	    return tmp;
    }

    public static int[] rndUniqueArray(int n, int m) {
	    if (m < n)
	        throw new IllegalArgumentException("Liczba elementw wiksza od liczby dopuszczalnych wartoci!");
	    int[] tmp = new int[n];
	    Random rnd = new Random();
	    int j = 0;
	    tmp[j++] = rnd.nextInt(m);
	    do {
		    int k = rnd.nextInt(m);
		    boolean jest = false;
		    for(int i = 0; i < j; ++i) 
		        if (k == tmp[i]) jest = true;
		    if (!jest) 
			    tmp[j++] = k;
	    } while (j < n);
	    return tmp;
    }
    
    public static int[] rndSortUniqueArray(int n, int m) {
	    if (m < n)
	        throw new IllegalArgumentException("Liczba elementw wiksza od liczby dopuszczalnych wartoci!");
	    int[] tmp = new int[n];
	    Random rnd = new Random();
	    int j = 0;
	    tmp[j++] = rnd.nextInt(m);
	    do {
		    int k = rnd.nextInt(m);
		    boolean jest = false;
		    for(int i = 0; i < j; ++i) 
		        if (k == tmp[i]) jest = true;
		    if (!jest) 
			    tmp[j++] = k;
	    } while (j < n);
	    Arrays.sort(tmp);
	    return tmp;
    }
    
    public static void arrayPrint(int[] tab) {
	    int n = tab.length;
	    for(int i = 0; i < n; ++i)
	        System.out.print(tab[i]+" ");
    }
    
    public static void arrayPrintln(int[] tab) {
	    int n = tab.length;
	    for(int i = 0; i < n; ++i)
	        System.out.print(tab[i]+" ");
	    System.out.println();    
    }

    public static void addToArray(int[] tab, int d) {
	    int n = tab.length;
	    for(int i = 0; i < n; ++i)
	        tab[i] += d;
    }
    
    /* tablice liczb typu double */
    public static double[] rndArray(int n, double a) {
	    Random rnd = new Random();
	    double[] tmp = new double[n];
	    for(int i = 0; i < n; ++i) 
	        tmp[i] = a*rnd.nextDouble();
	    return tmp;
    }
    
    public static double[] rndArray(int n, double a, int prec) {
	    Random rnd = new Random();
	    double wsp = Math.pow(10.0, prec);
	    double[] tmp = new double[n];
	    for(int i = 0; i < n; ++i) 
	        tmp[i] = (int)(a*rnd.nextDouble()*wsp+0.5)/wsp;
	    return tmp;
    }
    
    public static double[] rndArray(int n, double a, double step) {
	    Random rnd = new Random();
	    int k = (int)(a/step)+1;
	    double wsp = Math.pow(10.0, 1+(int)Math.log10(1/step));
	    double[] tmp = new double[n];
	    for(int i = 0; i < n; ++i) 
	        tmp[i] = (int)(step*rnd.nextInt(k)*wsp+0.5)/wsp;
	    return tmp;
    }
    
    public static double[] rndUniqueArray(int n, double a) {
	    double[] tmp = new double[n];
	    Random rnd = new Random();
	    int j = 0;
	    tmp[j++] = a*rnd.nextDouble();
	    do {
		    double x = a*rnd.nextDouble();
		    boolean jest = false;
		    for(int i = 0; i < j; ++i) 
		        if (x == tmp[i]) jest = true;
		    if (!jest) 
			    tmp[j++] = x;
	    } while (j < n);
	    return tmp;
    }
    
    public static double[] rndSortArray(int n, double a) {
	    Random rnd = new Random();
	    double[] tmp = new double[n];
	    for(int i = 0; i < n; ++i) 
	        tmp[i] = a*rnd.nextDouble();
	    Arrays.sort(tmp);
	    return tmp;
    }
    
    public static double[] rndSortUniqueArray(int n, double a) {
	    double[] tmp = new double[n];
	    Random rnd = new Random();
	    int j = 0;
	    tmp[j++] = a*rnd.nextDouble();
	    do {
		    double x = a*rnd.nextDouble();
		    boolean jest = false;
		    for(int i = 0; i < j; ++i) 
		        if (x == tmp[i]) jest = true;
		    if (!jest) 
			    tmp[j++] = x;
	    } while (j < n);
	    Arrays.sort(tmp);
	    return tmp;
    }
    
    public static void arrayPrint(double[] tab) {
	    int n = tab.length;
	    for(int i = 0; i < n; ++i)
	        System.out.print(tab[i]+" ");
    }
    
    public static void arrayPrintln(double[] tab) {
	    int n = tab.length;
	    for(int i = 0; i < n; ++i)
	        System.out.print(tab[i]+" ");
	    System.out.println();    
    }
        
    public static void arrayPrintf(String spec, double[] tab) {
	    int n = tab.length;
	    for(int i = 0; i < n; ++i)
	        System.out.printf(spec, tab[i]);
    }
   
    public static void addToArray(double[] tab, double d) {
	    int n = tab.length;
	    for(int i = 0; i < n; ++i)
	        tab[i] += d;
    }
    
    public static void roundArray(double[] tab, int prec) {
        int n = tab.length;
        double wsp = Math.pow(10.0, prec);
        for(int i = 0; i < n; ++i) 
            tab[i] = (int)(tab[i]*wsp+0.5)/wsp;
    }

    public static double round(double x, int prec) {
	    double wsp = Math.pow(10.0, prec);
        return(int)(x*wsp+0.5)/wsp;
    }
    
    public static float round(float x, int prec) {
	    float wsp = (float) Math.pow(10.0, prec);
        return (int)(x*wsp+0.5)/wsp;
    }
    
    public static double random(double a, int prec) {
        return round(a*Math.random(), prec);
    }
    
}
