import java.util.Scanner;
/** Klasa <code>MyIntArray</code> zawiera statyczne metody uatwiajce
  * wprowadzanie danych do jednowymiarowej tablicy liczb cakowitych,
  * wywietlanie zawartoci tablicy na konsoli oraz konwertowania tablicy
  * liczb zmiennoprzecinkowych na tablic liczb cakowitych.
  * @author Wiesaw Rychlicki
  * @version 1.0 (2012-02-06)
  */

public class MyIntArray {
/** Umoliwia wprowadzanie danych liczbowych (typu <code>int</code>)
  * z konsoli do tablicy. Dane wprowadzane s przy uyciu metod z klasy
  * <code>java.util.Scanner</code>. Podczas wprowadzania danych 
  * wywietlana jest informacja postaci: <code>Liczba 2 z 5, n = </code>.
  * @param tab jednowymiarowa tablica liczb cakowitych.
  */
	public static void input(int[] tab) {
	    int n = tab.length;
	    Scanner input = new Scanner(System.in);
	    for(int i = 0; i < n; ++i) { 
		    System.out.printf("Liczba %d z %d, n = ", i+1, n);
	        tab[i] = input.nextInt();
        }
    }
/** Umoliwia wywietlanie liczb zawartych w tablicy na konsoli.
  * Kolejne liczby oddzielane s odstpem.
  * @param tab jednowymiarowa tablica liczb cakowitych.
  */   
    public static void print(int[] tab) {
	    int n = tab.length;
	    for(int i = 0; i < n; ++i)
	        System.out.print(tab[i]+" ");
    }
/** Umoliwia wywietlanie liczb zawartych w tablicy na konsoli.
  * Kolejne liczby oddzielane s odstpem. Po wywietleniu ostaniej
  * liczby, do konsoli przesyany jest znak koca linii.
  * @param tab jednowymiarowa tablica liczb cakowitych.
  */
    public static void println(int[] tab) {
	    int n = tab.length;
	    for(int i = 0; i < n; ++i)
	        System.out.print(tab[i]+" ");
	    System.out.println();    
    }
/** Zwraca jednowymiarow tablic liczb typu <code>double</code>, 
  * o wartociach rwnych wartociom tablicy liczb cakowitych 
  * przekazanej jako parametr.
  * @param tab jednowymiarowa tablica liczb cakowitych.
  */
	public static double[] toDoubleArray(int[] tab) {
	    int n = tab.length;
	    double[] tmp = new double[n];
	    for(int i = 0; i < n; ++i)  
		    tmp[i] = (double)tab[i];
        return tmp;
    }
/** Zwraca jednowymiarow tablic liczb typu <code>int</code>, 
  * o wartociach odpowiadajcym (zaokrglenie w d) wartociom
  * elementw tablicy liczb zmiennoprzecinkowych typu <code>double</code>
  * przekazanej jako parametr.
  * @param tab jednowymiarowa tablica liczb zmiennoprzecinkowych typu 
  * <code>double</code>.
  */
    public static int[] toIntArray(double[] tab) {
        int n = tab.length;
        int[] tmp = new int[n];
        for(int i = 0; i < n; ++i)  
            tmp[i] = (int)tab[i];
        return tmp;
    }
}


