import java.util.Scanner;
/** Zadanie Z22.2 */
public class Z22_2 {
	private static final String[] rz = {"M", "CM", "D", "CD", "C", "XC", 
	    "L", "XL", "X", "IX", "V", "IV", "I"};
    private static final int[] ar = {1000, 900, 500, 400, 100, 90, 
        50, 40, 10, 9, 5, 4, 1};
    private static final int[] lp = {3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3};
    private static final String[] err = {"CMD", "CMC", "XCL", "XCX", "IXV", 
        "IXI", "DCD", "CDC", "LXL", "XLX", "VIV", "IVI"};
        
	public static void main(String args[]) {
		Scanner input = new Scanner(System.in);
		System.out.println("Odczytywanie rzymskich liczb (zakres 1..3999)"); 
		String roman;
		do {
			System.out.print("Podaj liczb rzymsk: ");
			roman = input.next();			
			if (roman.equals("")) 
			    break;
		    
            for (String x: err)
                if (roman.indexOf(x) != -1)
                    throw new ArithmeticException("Niewaciwy cig znakw: "+x+" w "+roman);                  

            int tmp = 0;    // warto pocztkowa wyniku 
			int index = 0;  // indeks analizowanego znaku 
			for (int i = 0; i < 13; i++) {
                int powt = 0;
                while (roman.startsWith(rz[i], index)) {
                    tmp += ar[i];
                    index += rz[i].length();
                    ++powt;
                }
                if (powt > lp[i])
                    throw new ArithmeticException("Za duo znakw: "+rz[i]+" w "+roman);
            } 
            if (index != roman.length())
                throw new ArithmeticException("Niewaciwa liczba rzymska: "+roman); 		              
            System.out.println(roman+" = "+tmp);
		} while (true);
    }
}
