import java.util.Random;
import java.util.Arrays;
/** Klasa <code>MyRandomArray</code> zawiera statyczne metody 
  * wypeniajce jednowymiarowe tablice liczb cakowitych lub 
  * zmiennoprzecinkowych wartociami pseudolosowymi.
  * Umoliwia wywietlanie zawartoci tablic na konsoli oraz 
  * konwertowanie tablic na tablice z innym typem danych liczbowych.
  * @author Wiesaw Rychlicki
  * @version 1.0 (2012-02-06)
  */
public class MyRandomArray {
/** Zwraca <code>n</code> elementow tablic liczb cakowitych 
  * pseudolosowych typu <code>int</code>, z zakresu od <code>0</code> 
  * do <code>m-1</code>.
  * @param n liczba naturalna, rozmiar zwracanej tablicy,
  * @param m liczba naturalna, okrelajca zakres losowanych wartoci 
  * (od <code>0</code> do <code>m-1</code>).
   * @throws java.lang.NegativeArraySizeException gdy podany wymiar 
  * tablicy (<code>n</code>) jest liczb ujemn.
  * @throws java.lang.IllegalArgumentException gdy podany zakres 
  * (<code>m</code>) nie jest liczb dodatni.
  */
    public static int[] rndArray(int n, int m) {
	    Random rnd = new Random();
	    int[] tmp = new int[n];
	    for(int i = 0; i < n; ++i) 
	        tmp[i] = rnd.nextInt(m);
	    return tmp;
    }
/** Zwraca posortowan, <code>n</code> elementow tablic liczb
  * cakowitych pseudolosowych typu <code>int</code>, z zakresu od 
  * <code>0</code> do <code>m-1</code>.
  * @param n liczba naturalna, rozmiar zwracanej tablicy,
  * @param m liczba naturalna, okrelajca zakres losowanych wartoci 
  * (od <code>0</code> do <code>m-1</code>).
  * @throws java.lang.NegativeArraySizeException gdy podany wymiar 
  * tablicy (<code>n</code>) jest liczb ujemn.
  * @throws java.lang.IllegalArgumentException gdy podany zakres 
  * (<code>m</code>) nie jest liczb dodatni.
  */
    public static int[] rndSortArray(int n, int m) {
	    Random rnd = new Random();
	    int[] tmp = new int[n];
	    for(int i = 0; i < n; ++i) 
	        tmp[i] = rnd.nextInt(m);
	    Arrays.sort(tmp);
	    return tmp;
    }
/** Zwraca <code>n</code> elementow tablic liczb cakowitych 
  * pseudolosowych typu <code>int</code>, o nie powtarzajcych si 
  * wartociach z zakresu od <code>0</code> do <code>m-1</code>.
  * @param n liczba naturalna, rozmiar zwracanej tablicy,
  * @param m liczba naturalna, okrelajca zakres losowanych wartoci 
  * (od <code>0</code> do <code>m-1</code>).
  * @throws java.lang.NegativeArraySizeException gdy podany wymiar 
  * tablicy (<code>n</code>) jest liczb ujemn.
  * @throws java.lang.IllegalArgumentException gdy podany zakres 
  * (<code>m</code>) nie jest liczb dodatni.
  * @throws java.lang.IllegalArgumentException gdy liczba elementw 
  * tablicy jest wiksza od liczby moliwych wartoci 
  * (<code>n &gt; m</code>).
  */
    public static int[] rndUniqueArray(int n, int m) {
	    if (m < n)
	        throw new IllegalArgumentException("Liczba elementw wiksza od liczby dopuszczalnych wartoci!");
	    int[] tmp = new int[n];
	    Random rnd = new Random();
	    int j = 0;
	    tmp[j++] = rnd.nextInt(m);
	    do {
		    int k = rnd.nextInt(m);
		    boolean jest = false;
		    for(int i = 0; i < j; ++i) 
		        if (k == tmp[i]) jest = true;
		    if (!jest) 
			    tmp[j++] = k;
	    } while (j < n);
	    return tmp;
    }
/** Zwraca posortowan, <code>n</code> elementow tablic liczb 
  * cakowitych pseudolosowych typu <code>int</code>, o nie 
  * powtarzajcych si wartociach z zakresu od <code>0</code> do 
  * <code>m-1</code>.
  * @param n liczba naturalna, rozmiar zwracanej tablicy,
  * @param m liczba naturalna, okrelajca zakres losowanych wartoci 
  * (od <code>0</code> do <code>m-1</code>).
  * @throws java.lang.NegativeArraySizeException gdy podany wymiar 
  * tablicy (<code>n</code>) jest liczb ujemn.
  * @throws java.lang.IllegalArgumentException gdy podany zakres 
  * (<code>m</code>) nie jest liczb dodatni.
  * @throws java.lang.IllegalArgumentException gdy liczba elementw 
  * tablicy jest wiksza od liczby moliwych wartoci 
  * (<code>n &gt; m</code>).
  */
    public static int[] rndSortUniqueArray(int n, int m) {
	    if (m < n)
	        throw new IllegalArgumentException("Liczba elementw wiksza od liczby dopuszczalnych wartoci!");
	    int[] tmp = new int[n];
	    Random rnd = new Random();
	    int j = 0;
	    tmp[j++] = rnd.nextInt(m);
	    do {
		    int k = rnd.nextInt(m);
		    boolean jest = false;
		    for(int i = 0; i < j; ++i) 
		        if (k == tmp[i]) jest = true;
		    if (!jest) 
			    tmp[j++] = k;
	    } while (j < n);
	    Arrays.sort(tmp);
	    return tmp;
    }
/** Wywietla liczby zawarte w tablicy na konsoli, oddzielajc kolejne 
  * wartoci odstpem.
  * @param tab jednowymiarowa tablica liczb cakowitych.
  */
    public static void arrayPrint(int[] tab) {
	    int n = tab.length;
	    for(int i = 0; i < n; ++i)
	        System.out.print(tab[i]+" ");
    }
/** Wywietla liczby zawarte w tablicy na konsoli, oddzielajc kolejne
  * wartoci odstpem. Po wywietleniu ostaniej liczby, do konsoli 
  * przesyany jest znak koca linii.
  * @param tab jednowymiarowa tablica liczb cakowitych.
  */
    public static void arrayPrintln(int[] tab) {
	    int n = tab.length;
	    for(int i = 0; i < n; ++i)
	        System.out.print(tab[i]+" ");
	    System.out.println();    
    }
/** Dodaje do wszystkich liczb zawartych w tablicy podan liczb 
  * cakowit.
  * @param tab jednowymiarowa tablica liczb cakowitych typu 
  * <code>int</code>,
  * @param d liczba cakowita typu <code>int</code>.
  */ 
    public static void addToArray(int[] tab, int d) {
	    int n = tab.length;
	    for(int i = 0; i < n; ++i)
	        tab[i] += d;
    }
    
/** Zwraca <code>n</code> elementow tablic liczb zmiennoprzecinkowych 
  * pseudolosowych typu <code>double</code> z okrelonego przedziau.
  * @param n liczba naturalna, rozmiar zwracanej tablicy,
  * @param a liczba zmiennoprzecinkowa typu <code>double</code>, 
  * okrelajca przedzia losowanych wartoci:
  * <br> <code>&lt;0, a)</code> - dla <code>a &gt 0</code>,
  * <br> <code>(a, 0&gt</code> - dla <code>a &lt 0</code>.
  * <br> Dla <code>a = 0</code> otrzymamy tablic wypenion zerami.
  * @throws java.lang.NegativeArraySizeException gdy podany wymiar 
  * tablicy (<code>n</code>) jest liczb ujemn.
  */
    public static double[] rndArray(int n, double a) {
	    Random rnd = new Random();
	    double[] tmp = new double[n];
	    for(int i = 0; i < n; ++i) 
	        tmp[i] = a*rnd.nextDouble();
	    return tmp;
    }
 
/** Zwraca <code>n</code> elementow tablic liczb zmiennoprzecinkowych 
  * pseudolosowych typu <code>double</code> z okrelonego przedziau,
  * zaokrglonych z podan precyzj.
  * @param n liczba naturalna, rozmiar zwracanej tablicy,
  * @param a liczba zmiennoprzecinkowa typu <code>double</code>, 
  * okrelajca przedzia losowanych wartoci:
  * <br> <code>&lt;0, a)</code> - dla <code>a &gt 0</code>,
  * <br> <code>(a, 0&gt</code> - dla <code>a &lt 0</code>.
  * <br> Dla <code>a = 0</code> otrzymamy tablic wypenion zerami.
  * @param prec liczba miejsc po przecinku. 
  * @see #round
  * @throws java.lang.NegativeArraySizeException gdy podany wymiar 
  * tablicy (<code>n</code>) jest liczb ujemn.
  */        
    public static double[] rndArray(int n, double a, int prec) {
	    Random rnd = new Random();
	    double wsp = Math.pow(10.0, prec);
	    double[] tmp = new double[n];
	    for(int i = 0; i < n; ++i) 
	        tmp[i] = (int)(a*rnd.nextDouble()*wsp+0.5)/wsp;
	    return tmp;
    }
/** Zwraca <code>n</code> elementow tablic liczb zmiennoprzecinkowych 
  * pseudolosowych typu <code>double</code> z okrelonego przedziau,
  * rnicych si o wielokrotno podanego kroku (warto dodatnia).
  * @param n liczba naturalna, rozmiar zwracanej tablicy,
  * @param a liczba zmiennoprzecinkowa typu <code>double</code>, 
  * okrelajca przedzia losowanych wartoci:
  * <br> <code>&lt;0, a)</code> - dla <code>a &gt 0</code>,
  * <br> <code>(a, 0&gt</code> - dla <code>a &lt 0</code>.
  * <br> Dla <code>a = 0</code> otrzymamy tablic wypenion zerami.
  * @param step krok, najmniejsza moliwa rnica pomidzy liczbami 
  * w tablicy (rnice pomidzy wartociami liczb w tablicy s 
  * wielokrotnoci parametru <code>step</code>. 
  * @throws java.lang.NegativeArraySizeException gdy podany wymiar 
  * tablicy (<code>n</code>) jest liczb ujemn.
  * @throws java.lang.IllegalArgumentException gdy podany parametr 
  * <code>step</code>) nie jest liczb dodatni.
  */
    public static double[] rndArray(int n, double a, double step) {
	    Random rnd = new Random();
	    int k = (int)(a/step)+1;
	    double wsp = Math.pow(10.0, 1+(int)Math.log10(1/step));
	    double[] tmp = new double[n];
	    for(int i = 0; i < n; ++i) 
	        tmp[i] = (int)(step*rnd.nextInt(k)*wsp+0.5)/wsp;
	    return tmp;
    }
/** Zwraca <code>n</code> elementow tablic liczb zmiennoprzecinkowych 
  * pseudolosowych typu <code>double</code> z okrelonego przedziau,
  * o nie powtarzajcych si wartociach.
  * @param n liczba naturalna, rozmiar zwracanej tablicy,
  * @param a liczba zmiennoprzecinkowa typu <code>double</code>, 
  * okrelajca przedzia losowanych wartoci:
  * <br> <code>&lt;0, a)</code> - dla <code>a &gt 0</code>,
  * <br> <code>(a, 0&gt</code> - dla <code>a &lt 0</code>.
  * <br> Dla <code>a = 0</code> otrzymamy tablic wypenion zerami.
  * @throws java.lang.NegativeArraySizeException gdy podany wymiar 
  * tablicy (<code>n</code>) jest liczb ujemn.
  * @throws java.lang.IllegalArgumentException gdy podany parametr 
  * <code>a</code> jest zerem.
  */    
    public static double[] rndUniqueArray(int n, double a) {
	    if (a == 0)
            throw new IllegalArgumentException("a = 0.0");
	    double[] tmp = new double[n];
	    Random rnd = new Random();
	    int j = 0;
	    tmp[j++] = a*rnd.nextDouble();
	    do {
		    double x = a*rnd.nextDouble();
		    boolean jest = false;
		    for(int i = 0; i < j; ++i) 
		        if (x == tmp[i]) jest = true;
		    if (!jest) 
			    tmp[j++] = x;
	    } while (j < n);
	    return tmp;
    }
/** Zwraca posortowan, <code>n</code> elementow tablic liczb 
  * zmiennoprzecinkowych pseudolosowych typu <code>double</code> 
  * z okrelonego przedziau.
  * @param n liczba naturalna, rozmiar zwracanej tablicy,
  * @param a liczba zmiennoprzecinkowa typu <code>double</code>, 
  * okrelajca przedzia losowanych wartoci:
  * <br> <code>&lt;0, a)</code> - dla <code>a &gt 0</code>,
  * <br> <code>(a, 0&gt</code> - dla <code>a &lt 0</code>.
  * <br> Dla <code>a = 0</code> otrzymamy tablic wypenion zerami.
  * @throws java.lang.NegativeArraySizeException gdy podany wymiar 
  * tablicy (<code>n</code>) jest liczb ujemn.
  */
    public static double[] rndSortArray(int n, double a) {
	    Random rnd = new Random();
	    double[] tmp = new double[n];
	    for(int i = 0; i < n; ++i) 
	        tmp[i] = a*rnd.nextDouble();
	    Arrays.sort(tmp);
	    return tmp;
    }
/** Zwraca posortowan, <code>n</code> elementow tablic liczb 
  * zmiennoprzecinkowych pseudolosowych typu <code>double</code> 
  * z okrelonego przedziau, o nie powtarzajcych si wartociach.
  * @param n liczba naturalna, rozmiar zwracanej tablicy,
  * @param a liczba zmiennoprzecinkowa typu <code>double</code>, 
  * okrelajca przedzia losowanych wartoci:
  * <br> <code>&lt;0, a)</code> - dla <code>a &gt 0</code>,
  * <br> <code>(a, 0&gt</code> - dla <code>a &lt 0</code>.
  * <br> Dla <code>a = 0</code> otrzymamy tablic wypenion zerami.
  * @throws java.lang.NegativeArraySizeException gdy podany wymiar 
  * tablicy (<code>n</code>) jest liczb ujemn.
  * @throws java.lang.IllegalArgumentException gdy podany parametr 
  * <code>a</code> jest zerem.
  */    
    public static double[] rndSortUniqueArray(int n, double a) {
	    if (a == 0)
            throw new IllegalArgumentException("a = 0.0");
	    double[] tmp = new double[n];
	    Random rnd = new Random();
	    int j = 0;
	    tmp[j++] = a*rnd.nextDouble();
	    do {
		    double x = a*rnd.nextDouble();
		    boolean jest = false;
		    for(int i = 0; i < j; ++i) 
		        if (x == tmp[i]) jest = true;
		    if (!jest) 
			    tmp[j++] = x;
	    } while (j < n);
	    Arrays.sort(tmp);
	    return tmp;
    }
/** Wywietla liczby zawarte w tablicy na konsoli, oddzielajc kolejne 
  * wartoci odstpem.
  * @param tab jednowymiarowa tablica liczb typu <code>double</code>.
  */    
    public static void arrayPrint(double[] tab) {
	    int n = tab.length;
	    for(int i = 0; i < n; ++i)
	        System.out.print(tab[i]+" ");
    }
/** Wywietla liczby zawarte w tablicy na konsoli, oddzielajc kolejne
  * wartoci odstpem. Po wywietleniu ostaniej liczby, do konsoli 
  * przesyany jest znak koca linii.
  * @param tab jednowymiarowa tablica liczb typu <code>double</code>.
  */
    public static void arrayPrintln(double[] tab) {
	    int n = tab.length;
	    for(int i = 0; i < n; ++i)
	        System.out.print(tab[i]+" ");
	    System.out.println();    
    }
/** Wywietla sformatowane liczby (zpisane w tablicy) na konsoli. Sposb 
  * formatowania okrelony jest przy pomocy parametru <code>spec</code>, 
  * zbudowanego wz zasad zdefiniowanych w klasie 
  * <a href="http://docs.oracle.com/javase/1.5.0/docs/api/java/util/Formatter.html">
  * Formatter</a>, np.: <code>"%.2f "</code> - wywietla liczb 
  * zmiennoprzecinkow z dwoma miejscami po przecinku.
  * @param spec acuch znakw okrelajcy format liczby.
  * @param tab jednowymiarowa tablica liczb typu <code>double</code>.
  */
    public static void arrayPrintf(String spec, double[] tab) {
	    int n = tab.length;
	    for(int i = 0; i < n; ++i)
	        System.out.printf(spec, tab[i]);
    }
/** Dodaje do wszystkich liczb zawartych w tablicy podan liczb 
  * zmiennoprzecinkow typu <code>double</code>.
  * @param tab jednowymiarowa tablica liczb zmiennoprzecinkowych typu 
  * <code>double</code>,
  * @param d liczba zmiennoprzecinkowa typu <code>double</code>.
  */   
    public static void addToArray(double[] tab, double d) {
	    int n = tab.length;
	    for(int i = 0; i < n; ++i)
	        tab[i] += d;
    }
/** Zaokrgla wszystkie liczby zawarte w tablicy z okrelon precyzj.
  * @param tab jednowymiarowa tablica liczb zmiennoprzecinkowych typu 
  * <code>double</code>,
  * @param prec liczba cakowita typu <code>int</code>, precyzja 
  * zaokrglenia.
  * @see #round
  */     
    public static void roundArray(double[] tab, int prec) {
        int n = tab.length;
        double wsp = Math.pow(10.0, prec);
        for(int i = 0; i < n; ++i) 
            tab[i] = (int)(tab[i]*wsp+0.5)/wsp;
    }
/** Zwraca liczb zmiennoprzecinkow typu <code>double</code> zaokrglon 
  * z okrelon precyzj.
  * @param x liczba zmiennoprzecinkowa typu <code>double</code>.
  * @param prec liczba cakowita typu <code>int</code> okrelajca 
  * precyzj zaokrglenia:
  * <br><code>prec &gt; 0</code> - liczba miejsc po przecinku,
  * <br><code>prec = 0</code> - zaokrglenie do wartoci cakowitej,
  * <br><code>prec &lt; 0</code> - warto bezwzgldna liczby 
  * <code>prec</code> okrela liczb zer przed przecinkiem, zaokrglenie 
  * do penych dziesitek (<code>-1</code>), setek (<code>-2</code>) itd.
  */
    public static double round(double x, int prec) {
	    double wsp = Math.pow(10.0, prec);
        return(int)(x*wsp+0.5)/wsp;
    }
/** Zwraca liczb zmiennoprzecinkow typu <code>float</code> zaokrglon 
  * z okrelon precyzj.
  * @param x liczba zmiennoprzecinkowa typu <code>float</code>.
  * @param prec liczba cakowita typu <code>int</code> okrelajca 
  * precyzj zaokrglenia:
  * <br><code>prec &gt; 0</code> - liczba miejsc po przecinku,
  * <br><code>prec = 0</code> - zaokrglenie do wartoci cakowitej,
  * <br><code>prec &lt; 0</code> - warto bezwzgldna liczby 
  * <code>prec</code> okrela liczb zer przed przecinkiem, zaokrglenie 
  * do penych dziesitek (<code>-1</code>), setek (<code>-2</code>) itd.
  */
    
    public static float round(float x, int prec) {
	    float wsp = (float) Math.pow(10.0, prec);
        return (int)(x*wsp+0.5)/wsp;
    }
/** Zwraca pseudolosow licz zmiennoprzecinkow typu <code>double</code> 
  * z okrelonego przedziau, zaokrglon z podan precyzj.
  * @param a liczba zmiennoprzecinkowa typu <code>double</code>, 
  * okrelajca przedzia losowanej wartoci:
  * <br> <code>&lt;0, a)</code> - dla <code>a &gt 0</code>,
  * <br> <code>(a, 0&gt</code> - dla <code>a &lt 0</code>.
  * <br> Dla <code>a = 0</code> otrzymamy warto <code>0.0</code>.
  * @param prec precyzja zaokrglenia.
  * @see #round
  */
    public static double random(double a, int prec) {
        return round(a*Math.random(), prec);
    }
/** Zwraca pseudolosow licz zmiennoprzecinkow typu <code>float</code> 
  * z okrelonego przedziau, zaokrglon z podan precyzj.
  * @param a liczba zmiennoprzecinkowa typu <code>float</code>, 
  * okrelajca przedzia losowanej wartoci:
  * <br> <code>&lt;0, a)</code> - dla <code>a &gt 0</code>,
  * <br> <code>(a, 0&gt</code> - dla <code>a &lt 0</code>.
  * <br> Dla <code>a = 0</code> otrzymamy warto <code>0.0f</code>.
  * @param prec precyzja zaokrglenia.
  * @see #round
  */
    public static float random(float a, int prec) {
        return (float) round(a*Math.random(), prec);
    }
}
