/** Klasa <code>Z19_3</code> stanowi prosty przykad aplikacji
  * konsolowej.Pocztki programowania w wielu jzykach zawieraj ten
  * klasyczny przykad - wywietlanie na konsoli napisu <b>Hello 
  * World!</b> czyli <i>Witaj wiecie!</i>.
  * <p>To radosny "okrzyk", wydawany przez kadego pocztkujcego
  * programist, po napisaniu pierwszego prostego programu w poznawanym
  * jzyku.</p>
  * <p>Zobacz przykady takich programw: 
  * <a href="http://en.wikipedia.org/wiki/Hello_world_program_examples"
  * target="_blank"> Hello world program examples.</a></p>
  */
public class Z19_3 {
/** Identyfikator staej (zmiennej, ktrej wartoci nie moemy zmieni),
  * zawierajcej acuch znakw <code>Hello World!"</code>. Zwyczajowo 
  * takie identyfikatory zapisujemy wielkimi literami. Prywatna staa
  * <code>HELLO</code> jest dostpna wycznie wewntrz klasy
  * <code>Z19_3</code>. Zastosowanie staej przedstawimy w dwch 
  * przykadach:
  * <p><b>Przykad 1.</b>
  * <code><br>static String hello() {<br>&nbsp;&nbsp;&nbsp;&nbsp;
  * return HELLO;<br>}</code></p>
  * <p><b>Przykad 2.</b>
  * <code><br>System.out.println("Jeszcze raz: "+HELLO");</code></p>
  */
	private static final String HELLO = "Hello World!";
/** Metoda zwraca acuch znakw - jest to napis zawarty w staej
  * <code>HELLO</code>. Metoda jest widoczna w pakiecie. Metody z innych
  * klas pakietu mog t metod wywoa: <code>Z19_3.hello();</code>
  */
    static String hello() {
	    return HELLO;
    }
/** Metoda <code>main()</code> jest miejscem, od ktrego rozpoczyna si
  * wykonywanie programu. Program moe skada si z wielu klas, ale
  * tylko jedna z nich moe zawiera publiczn, statyczn i nie
  * zwracajc adnej wartoci (<code>public static void</code>) metod
  * <code>main()</code>. Metoda <code>main()</code>
  * posiada obowizkowo jeden parametr.<br>
  * Metod <code>main()</code> moemy uruchomi wewntrz innej klasy:
  * <p><b>Przykad 1.</b><code><br>Z19_3.main(null);<br>}<br></code>
  * Do metody <code>main()</code> z klasy <code>Z19_3</code> nie 
  * przekazano adnych parametrw.</p>
  * <p><b>Przykad 2.</b><code><br>String[] p = {"par1", "par2"};<br>
  * Z19_3.main(p);<br></code> Do metody <code>main()</code> z klasy
  * <code>Z19_3</code> przekazano dwa parametry <code>"par1"</code>
  * i <code>"par2".</code></p>
  * @param args tablica argumentw (egzemplarzy klasy <code>String 
  * </code>), przekazywana przez system do metody <code>main()</code>.
  * Identyfikator <code>args</code> jest skrtem sowa argumenty (ang. 
  * <i>arguments</i>) i moe by zastpiony dowolnym innym, poprawnie
  * zbudowanym identyfikatorem.
  */
    public static void main(String[] args) {
        System.out.println(hello());
        System.out.println("Jeszcze raz: "+HELLO);
    }
/** Bezparametrowy konstruktor <code>Z19_3()</code> pozwala na tworzenie
  * obiektw klasy <code>Z19_3</code> przez inne klasy. Umoliwia to 
  * wywoywanie metody <code>hello()</code> i metody <code>main()</code>
  * zdefiniowanej w klasie <code>Z19_3</code> przez te klasy.<br>
  * W przypadku metody <code>main()</code> musimy przekaza parametr - 
  * tablic argumentw. Parametr ten moe by tablic pust.<br>
  * <p><b>Przykad</b><br>
  * <code>Z19_3 x = new Z19_3();<br>
  * System.out.println(x.hello());<br>
  * x.main(null);<br></code></p>
  */
    public Z19_3(){}  
}