package grpc

import (
  grpctransport "github.com/go-kit/kit/transport/grpc"
  "github.com/matryer/goblueprints/chapter10/vault"
  "github.com/matryer/goblueprints/chapter10/vault/pb"
  "google.golang.org/grpc"
)

// New tworzy nowego klienta vault.Service client.
func New(conn *grpc.ClientConn) vault.Service {
  var hashEndpoint = grpctransport.NewClient(
    conn, "Vault", "Hash",
    vault.EncodeGRPCHashRequest,
    vault.DecodeGRPCHashResponse,
    pb.HashResponse{},
  ).Endpoint()
  var validateEndpoint = grpctransport.NewClient(
    conn, "Vault", "Validate",
    vault.EncodeGRPCValidateRequest,
    vault.DecodeGRPCValidateResponse,
    pb.ValidateResponse{},
  ).Endpoint()
  return vault.Endpoints{
    HashEndpoint:     hashEndpoint,
    ValidateEndpoint: validateEndpoint,
  }
}
