#include <functional>
#include <iostream>
#include <string>
#include <vector>

#include <range/v3/view.hpp>
#include <range/v3/action.hpp>
#include <range/v3/istream_range.hpp>
#include <range/v3/to_container.hpp>

using namespace ranges::v3;

template <typename T>
class err;

template <typename Range>
void write_top_10(const Range& xs)
{
    auto items =
		// Przypisywanie indeksu do kadego z filmw.
		// Funkcja view::ints(1) zwraca nieskoczony zakres liczb cakowitych
		// zaczynajcy si od wartoci 1. Scalenie go z zakresem xs da nam zakres par.
		// Liczba elementw w tym zakresie bdzie rwna rozmiarowi zakresu xs.

        view::zip(xs, view::ints(1))
            | view::transform([] (const auto& pair) {
                    return std::to_string(pair.second) +
                           " " + pair.first;
            })
            | view::take(10);

    for (const auto& item: items) {
        std::cout << item << std::endl;
    }
}

int main(int argc, char *argv[])
{
    setlocale(LC_ALL, "polish");

    std::vector<std::string> movies_1 {
            "Sens ycia",
            "Dr Strangelove"
        };

    // Jeli w wektorze jest mniej ni 10 filmw, 
    // wszystkie z nich zostan wywietlone. Jeli w wektorze
    // jest wicej ni 10 filmw, tylko pierwszych 10 zostanie wywietlonych
    write_top_10(movies_1);
}
